/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMechanicalMachine;

public abstract class ContainerScreenMechanicalMachine<C extends ContainerMechanicalMachine<?>>
extends ContainerScreenExtended<C> {
    public ContainerScreenMechanicalMachine(C container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    public void drawEnergyBarTooltip(PoseStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((AbstractContainerScreen)this, (PoseStack)poseStack, (int)8, (int)16, (int)18, (int)60, (int)mouseX, (int)mouseY, () -> {
            int energyStored = ((ContainerMechanicalMachine)this.m_6262_()).getEnergy();
            int energyMax = ((ContainerMechanicalMachine)this.m_6262_()).getMaxEnergy();
            if (energyMax > 0) {
                return Optional.of(Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"general.integrateddynamics.energy"), Helpers.getLocalizedEnergyLevel(energyStored, energyMax)}));
            }
            return Optional.empty();
        });
    }

    public void drawFluidTankTooltip(PoseStack poseStack, FluidStack fluidStack, int fluidCapacity, int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((AbstractContainerScreen)this, (PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (int)mouseX, (int)mouseY, () -> {
            if (fluidStack != null && !fluidStack.isEmpty()) {
                Component fluidName = fluidStack.getDisplayName();
                return Optional.of(Lists.newArrayList((Object[])new Component[]{fluidName, DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)fluidStack.getAmount(), (int)fluidCapacity)}));
            }
            return Optional.empty();
        });
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
    }
}

