/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class BlockEntityCableConnectableInventory
extends CyclopsBlockEntity {
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private final ICable cable;
    private final INetworkCarrier networkCarrier;
    private final SimpleInventory inventory;

    public BlockEntityCableConnectableInventory(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize) {
        super(type, blockPos, blockState);
        this.inventory = this.createInventory(inventorySize, stackSize);
        this.cable = new CableTile<BlockEntityCableConnectableInventory>(this){

            @Override
            protected boolean isForceDisconnectable() {
                return false;
            }

            @Override
            protected EnumFacingMap<Boolean> getForceDisconnected() {
                return null;
            }

            @Override
            protected EnumFacingMap<Boolean> getConnected() {
                return ((BlockEntityCableConnectableInventory)this.tile).connected;
            }
        };
        this.addCapabilityInternal(CableConfig.CAPABILITY, LazyOptional.of(() -> this.cable));
        this.networkCarrier = new NetworkCarrierDefault();
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, LazyOptional.of(() -> this.networkCarrier));
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, LazyOptional.of(() -> new PathElementTile<BlockEntityCableConnectableInventory>(this, this.cable)));
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((SimpleInventory)this.inventory).getItemHandler()));
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, LazyOptional.of(() -> new SimpleInventoryState(this.getInventory())));
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public ICable getCable() {
        return this.cable;
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_6542_(Player entityplayer) {
                return BlockEntityCableConnectableInventory.this.f_58857_.m_7702_(BlockEntityCableConnectableInventory.this.f_58858_) == BlockEntityCableConnectableInventory.this;
            }
        };
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.connected.clear();
        this.inventory.readFromNBT(tag, "inventory");
    }

    public void m_183515_(CompoundTag tag) {
        this.inventory.writeToNBT(tag, "inventory");
        super.m_183515_(tag);
    }

    public void afterNetworkReAlive() {
    }

    @Nullable
    public INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            NetworkHelpers.invalidateNetworkElements(this.m_58904_(), this.m_58899_(), (BlockEntity)this);
        }
    }

    public static class Ticker<T extends BlockEntityCableConnectableInventory>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityCableConnectableInventory)((Object)blockEntity)).getConnected().isEmpty()) {
                ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getCable().updateConnections();
            }
            NetworkHelpers.revalidateNetworkElements(level, pos);
        }
    }
}

