/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.server;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import tfar.dankstorage.container.AbstractDankMenu;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.DankInventory;

public class C2SButtonPacket {
    private final Action action;

    public C2SButtonPacket(Action action) {
        this.action = action;
    }

    public C2SButtonPacket(FriendlyByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
    }

    public static void send(Action action) {
        DankPacketHandler.sendToServer(new C2SButtonPacket(action));
    }

    public void handleInternal(ServerPlayer player, Action action) {
        AbstractContainerMenu container = player.f_36096_;
        if (action.requiresContainer) {
            if (container instanceof AbstractDankMenu) {
                AbstractDankMenu dankContainer = (AbstractDankMenu)container;
                DankInventory inventory = dankContainer.dankInventory;
                switch (action) {
                    case LOCK_FREQUENCY: {
                        inventory.toggleFrequencyLock();
                        break;
                    }
                    case SORT: {
                        inventory.sort();
                        break;
                    }
                    case COMPRESS: {
                        inventory.compress(player);
                    }
                }
            }
        } else {
            switch (action) {
                case TOGGLE_TAG: {
                    Utils.toggleTagMode(player);
                    break;
                }
                case TOGGLE_PICKUP: {
                    Utils.togglePickupMode(player);
                    break;
                }
                case TOGGLE_USE_TYPE: {
                    Utils.toggleUseType(player);
                }
            }
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.action.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            if (player != null) {
                this.handleInternal(player, this.action);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Action {
        LOCK_FREQUENCY(true),
        PICK_BLOCK(false),
        SORT(true),
        TOGGLE_TAG(true),
        TOGGLE_PICKUP(false),
        TOGGLE_USE_TYPE(false),
        COMPRESS(true);

        private final boolean requiresContainer;

        private Action(boolean requiresContainer) {
            this.requiresContainer = requiresContainer;
        }
    }
}

