/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.DankInventory;

public class MixinHooks {
    public static boolean interceptItem(Inventory inv, ItemStack incoming) {
        Player player = inv.f_35978_;
        if (player.f_19853_.f_46443_ || incoming.m_41619_()) {
            return false;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack possibleDank = inv.m_8020_(i);
            if (!(possibleDank.m_41720_() instanceof DankItem) || !MixinHooks.onItemPickup(player, incoming, possibleDank)) continue;
            return true;
        }
        return false;
    }

    public static boolean onItemPickup(Player player, ItemStack pickup, ItemStack dank) {
        int i;
        PickupMode pickupMode = Utils.getPickupMode(dank);
        if (pickupMode == PickupMode.none) {
            return false;
        }
        DankInventory inv = Utils.getInventory(dank, player.f_19853_);
        if (inv == null) {
            DankStorage.LOGGER.warn("That's odd, the player somehow got an unassigned dank to change pickup mode");
            return false;
        }
        int count = pickup.m_41613_();
        boolean oredict = Utils.oredict(dank);
        ArrayList<ItemStack> existing = new ArrayList<ItemStack>();
        for (i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            boolean exists = false;
            for (ItemStack stack1 : existing) {
                if (!MixinHooks.areItemStacksCompatible(stack, stack1, oredict)) continue;
                exists = true;
            }
            if (exists) continue;
            existing.add(stack.m_41777_());
        }
        block0 : switch (pickupMode) {
            case pickup_all: {
                for (i = 0; i < inv.getSlots(); ++i) {
                    MixinHooks.allPickup(inv, i, pickup, oredict);
                    if (pickup.m_41619_()) break block0;
                }
                break;
            }
            case filtered_pickup: {
                for (i = 0; i < inv.getSlots(); ++i) {
                    MixinHooks.filteredPickup(inv, i, pickup, oredict, existing);
                    if (pickup.m_41619_()) break block0;
                }
                break;
            }
            case void_pickup: {
                for (i = 0; i < inv.getSlots(); ++i) {
                    MixinHooks.voidPickup(inv, i, pickup, oredict, existing);
                    if (pickup.m_41619_()) break block0;
                }
                break;
            }
        }
        if (pickup.m_41613_() != count) {
            dank.m_41754_(5);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
        return pickup.m_41619_();
    }

    public static void voidPickup(DankInventory inv, int slot, ItemStack toInsert, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (MixinHooks.doesItemStackExist(toInsert, filter, oredict) && MixinHooks.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.dankStats.stacklimit;
            int total = Math.min(toInsert.m_41613_() + existing.m_41613_(), stackLimit);
            inv.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)total));
            toInsert.m_41764_(0);
        }
    }

    public static void allPickup(DankInventory inv, int slot, ItemStack pickup, boolean oredict) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (existing.m_41619_()) {
            int stackLimit = inv.dankStats.stacklimit;
            int total = pickup.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setStackInSlot(slot, pickup.m_41777_());
                pickup.m_41764_(0);
            } else {
                inv.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)pickup, (int)stackLimit));
                pickup.m_41764_(remainder);
            }
            return;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)pickup, (ItemStack)existing) || oredict) {
            int stackLimit = inv.dankStats.stacklimit;
            int total = pickup.m_41613_() + existing.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)total));
                pickup.m_41764_(0);
            } else {
                inv.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)pickup, (int)stackLimit));
                pickup.m_41764_(remainder);
            }
        }
    }

    public static void filteredPickup(DankInventory inv, int slot, ItemStack toInsert, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (existing.m_41619_() && MixinHooks.doesItemStackExist(toInsert, filter, oredict)) {
            int stackLimit = inv.dankStats.stacklimit;
            int total = toInsert.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setStackInSlot(slot, toInsert.m_41777_());
                toInsert.m_41764_(0);
            } else {
                inv.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)stackLimit));
                toInsert.m_41764_(remainder);
            }
            return;
        }
        if (MixinHooks.doesItemStackExist(toInsert, filter, oredict) && MixinHooks.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.dankStats.stacklimit;
            int total = toInsert.m_41613_() + existing.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)total));
                toInsert.m_41764_(0);
            } else {
                inv.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)stackLimit));
                toInsert.m_41764_(remainder);
            }
        }
    }

    public static boolean areItemStacksCompatible(ItemStack stackA, ItemStack stackB, boolean oredict) {
        return oredict ? ItemStack.m_41658_((ItemStack)stackA, (ItemStack)stackB) && ItemStack.m_41746_((ItemStack)stackA, (ItemStack)stackB) : ItemStack.m_41658_((ItemStack)stackA, (ItemStack)stackB) && ItemStack.m_41746_((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean doesItemStackExist(ItemStack stack, List<ItemStack> filter, boolean oredict) {
        for (ItemStack filterStack : filter) {
            if (!MixinHooks.areItemStacksCompatible(stack, filterStack, oredict)) continue;
            return true;
        }
        return false;
    }
}

