/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.dto.microsoft;

import com.google.gson.annotations.SerializedName;
import org.jetbrains.annotations.Nullable;
import technicianlp.reauth.authentication.dto.ResponseObject;

public final class MicrosoftAuthResponse
implements ResponseObject {
    @SerializedName(value="access_token")
    public final String accessToken;
    @SerializedName(value="refresh_token")
    @Nullable
    public final String refreshToken;
    @SerializedName(value="error")
    @Nullable
    public final String error;

    private MicrosoftAuthResponse() {
        this.accessToken = null;
        this.refreshToken = null;
        this.error = null;
    }

    @Override
    public final boolean isValid() {
        return this.error == null && this.accessToken != null;
    }

    @Override
    @Nullable
    public final String getError() {
        return this.error;
    }

    @Override
    @Nullable
    public String getErrorDescription() {
        if (this.error == null) {
            return null;
        }
        switch (this.error) {
            case "invalid_grant": {
                return "reauth.error.expired";
            }
            case "temporarily_unavailable": {
                return "reauth.error.network";
            }
            case "authorization_declined": 
            case "expired_token": {
                return "reauth.error.cancelled";
            }
        }
        return null;
    }

    public final String getAccessToken() {
        return this.accessToken;
    }

    public final String getRefreshToken() {
        return this.refreshToken;
    }
}

