/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class RenderHelper {
    public static void drawTexture(PoseStack stack, ResourceLocation resource, double posX, double posY, double width, double height, double zLevel) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        RenderHelper.draw(stack, posX, posY, width, height, zLevel);
    }

    public static void draw(PoseStack stack, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.draw(stack, posX, posY, width, height, zLevel, 0.0, 1.0, 0.0, 1.0);
    }

    public static void draw(PoseStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, (float)posX, (float)(posY + height), (float)zLevel).m_7421_((float)u1, (float)v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).m_7421_((float)u2, (float)v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)posY, (float)zLevel).m_7421_((float)u2, (float)v1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)posX, (float)posY, (float)zLevel).m_7421_((float)u1, (float)v1).m_5752_();
        tessellator.m_85914_();
    }

    public static void startDrawBatch() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
    }

    public static void drawBatch(PoseStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_85982_(matrix, (float)posX, (float)(posY + height), (float)zLevel).m_7421_((float)u1, (float)v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).m_7421_((float)u2, (float)v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)posY, (float)zLevel).m_7421_((float)u2, (float)v1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)posX, (float)posY, (float)zLevel).m_7421_((float)u1, (float)v1).m_5752_();
    }

    public static void endDrawBatch() {
        Tesselator.m_85913_().m_85914_();
    }

    public static void drawColour(PoseStack graphics, int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RenderHelper.drawColour(graphics, r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(PoseStack graphics, int[] rgb, int alpha, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.drawColour(graphics, rgb[0], rgb[1], rgb[2], alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(PoseStack graphics, int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix = graphics.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(matrix, (float)posX, (float)(posY + height), (float)zLevel).m_6122_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).m_6122_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)posY, (float)zLevel).m_6122_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)posX, (float)posY, (float)zLevel).m_6122_(r, g, b, alpha).m_5752_();
        tessellator.m_85914_();
    }

    public static void colour(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void colour(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
    }

    public static int getRandomColourFromString(String s) {
        Random rand = new Random();
        rand.setSeed(Math.abs(s.hashCode() * 1000));
        int clr = Math.round(1.6777215E7f * rand.nextFloat());
        float[] hsb = new float[3];
        Color.RGBtoHSB(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF, hsb);
        hsb[2] = 0.65f + 0.25f * hsb[2];
        clr = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return clr;
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        double scaleW = (double)mc.m_91268_().m_85441_() / (double)mc.m_91268_().m_85445_();
        double scaleH = (double)mc.m_91268_().m_85442_() / (double)mc.m_91268_().m_85446_();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        RenderSystem.m_69488_((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.m_91268_().m_85442_() - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.m_91268_().m_85442_() - (double)y * scaleH) - (int)Math.floor((double)mc.m_91268_().m_85442_() - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        RenderSystem.m_69471_();
    }

    public static void renderTestScissor(PoseStack graphics) {
        Minecraft mc = Minecraft.m_91087_();
        RenderHelper.startGlScissor(mc.m_91268_().m_85445_() / 2 - 50, mc.m_91268_().m_85446_() / 2 - 50, 100, 100);
        RenderHelper.drawColour(graphics, 0xFFFFFF, 255, 0.0, 0.0, (double)mc.m_91268_().m_85445_(), (double)mc.m_91268_().m_85446_(), 0.0);
        RenderHelper.endGlScissor();
    }
}

