/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.core;

import java.util.function.Consumer;
import me.ichun.mods.ichunutil.loader.event.EventListener;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class EventHandlerClient {
    private EventListener<Minecraft> clientTickStartListener;
    private EventListener<Minecraft> clientTickEndListener;
    private EventListener<Minecraft> clientConnectListener;
    private EventListener<Minecraft> clientDisconnectListener;

    public abstract void registerKeyMapping(KeyMapping var1, String ... var2);

    protected abstract void registerAsClientTickStartListener(EventListener<Minecraft> var1);

    public final void registerClientTickStartListener(Consumer<Minecraft> consumer) {
        if (this.clientTickStartListener == null) {
            this.clientTickStartListener = new EventListener(this::registerAsClientTickStartListener);
        }
        this.clientTickStartListener.register(consumer);
    }

    protected abstract void registerAsClientTickEndListener(EventListener<Minecraft> var1);

    public final void registerClientTickEndListener(Consumer<Minecraft> consumer) {
        if (this.clientTickEndListener == null) {
            this.clientTickEndListener = new EventListener(this::registerAsClientTickEndListener);
        }
        this.clientTickEndListener.register(consumer);
    }

    protected abstract void registerAsOnClientConnectListener(EventListener<Minecraft> var1);

    public final void registerOnClientConnectListener(Consumer<Minecraft> consumer) {
        if (this.clientConnectListener == null) {
            this.clientConnectListener = new EventListener(this::registerAsOnClientConnectListener);
        }
        this.clientConnectListener.register(consumer);
    }

    protected abstract void registerAsOnClientDisconnectListener(EventListener<Minecraft> var1);

    public final void registerOnClientDisconnectListener(Consumer<Minecraft> consumer) {
        if (this.clientDisconnectListener == null) {
            this.clientDisconnectListener = new EventListener(this::registerAsOnClientDisconnectListener);
        }
        this.clientDisconnectListener.register(consumer);
    }

    public abstract boolean fireClientHandleSystemMessage(Component var1, boolean var2);

    public void fireLivingRenderPreEvent(LivingEntity entity, LivingEntityRenderer livingEntityRenderer, float partialTicks) {
    }

    public void fireClientLevelLoad(ClientLevel level) {
    }

    public abstract void fireOverlayChange(@Nullable Overlay var1, @Nullable Overlay var2);

    public boolean fireMouseScroll(double scrollDeltaX, double scrollDeltaY) {
        return false;
    }

    public String getPlayerName() {
        return Minecraft.m_91087_().m_91094_().m_92546_();
    }

    @Nullable
    public LocalPlayer getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Nullable
    public ClientLevel getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public String getLocalisedString(String s, Object ... params) {
        return I18n.m_118938_((String)s, (Object[])params);
    }
}

