/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.items.curios.armarium;

import com.hollingsworth.arsnouveau.api.item.ArsNouveauCurio;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.SecondaryIconPosition;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.event.FamiliarEvents;
import com.hollingsworth.arsnouveau.common.network.PacketSummonFamiliar;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import de.sarenor.arsinstrumentum.items.curios.armarium.ArmariumSlot;
import de.sarenor.arsinstrumentum.items.curios.armarium.ArmariumStorage;
import de.sarenor.arsinstrumentum.items.curios.armarium.Slots;
import de.sarenor.arsinstrumentum.network.Networking;
import de.sarenor.arsinstrumentum.network.WizardsArmariumChoiceMessage;
import de.sarenor.arsinstrumentum.setup.Registration;
import de.sarenor.arsinstrumentum.utils.CuriosUtil;
import de.sarenor.arsinstrumentum.utils.IterableUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class WizardsArmarium
extends ArsNouveauCurio {
    private static final Logger log = LogManager.getLogger(WizardsArmarium.class);
    public static final String WIZARDS_ARMARIUM_ID = "wizards_armarium";
    public static final String SWITCHED_TO_NO_HOTBAR = "instrumentum.armarium.hotbar_no_switch";
    public static final String SWITCHED_TO_HOTBAR = "instrumentum.armarium.hotbar_switch";
    private static final int HOTBAR_SIZE = 9;
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    @OnlyIn(value=Dist.CLIENT)
    public static void openSwitchRadialMenu(Player player) {
        ArmariumStorage armariumStorage = new ArmariumStorage(((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)Registration.WIZARDS_ARMARIUM.get()).get()).stack());
        Minecraft.m_91087_().m_91152_((Screen)new GuiRadialMenu(WizardsArmarium.getRadialMenuProvider(armariumStorage)));
    }

    public static void handleArmariumChoice(ServerPlayer player, int choosenSlot, Supplier<NetworkEvent.Context> ctx) {
        ArmariumStorage armariumStorage = new ArmariumStorage(((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)Registration.WIZARDS_ARMARIUM.get()).get()).stack());
        ArmariumSlot armariumSlot = armariumStorage.storeAndGet(IterableUtils.iterableToList(player.m_6168_()), player.m_150109_().f_35974_.subList(0, 9), CuriosUtil.getSpellfoci(player), WizardsArmarium.getFamiliarId(player), Slots.getSlotForInt(choosenSlot));
        WizardsArmarium.setArmor(player, armariumSlot.getArmor());
        if (armariumStorage.isHotbarSwitch()) {
            WizardsArmarium.setHotbar(player, armariumSlot.getHotbar());
        }
        WizardsArmarium.setFamiliar(player, armariumSlot.getFamiliarId(), ctx);
        CuriosUtil.setSpellfoci(player, armariumSlot.getSpellfoci());
    }

    public static void handleArmariumSwitch(ServerPlayer player, Supplier<NetworkEvent.Context> ctx) {
        ArmariumStorage armariumStorage = new ArmariumStorage(((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)Registration.WIZARDS_ARMARIUM.get()).get()).stack());
        ArmariumSlot armariumSlot = armariumStorage.storeAndGet(IterableUtils.iterableToList(player.m_6168_()), player.m_150109_().f_35974_.subList(0, 9), CuriosUtil.getSpellfoci(player), WizardsArmarium.getFamiliarId(player), null);
        WizardsArmarium.setArmor(player, armariumSlot.getArmor());
        if (armariumStorage.isHotbarSwitch()) {
            WizardsArmarium.setHotbar(player, armariumSlot.getHotbar());
        }
        WizardsArmarium.setFamiliar(player, armariumSlot.getFamiliarId(), ctx);
        CuriosUtil.setSpellfoci(player, armariumSlot.getSpellfoci());
    }

    public static void handleModeSwitch(ItemStack itemStack, Player player) {
        ArmariumStorage storage = new ArmariumStorage(itemStack);
        storage.switchIsHotbarSwitch(player);
        PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)(storage.isHotbarSwitch() ? SWITCHED_TO_HOTBAR : SWITCHED_TO_NO_HOTBAR)));
    }

    private static void setArmor(ServerPlayer player, List<ItemStack> armorItems) {
        for (EquipmentSlot equipmentSlot : ARMOR_SLOTS) {
            Optional<ItemStack> armorItem = armorItems.stream().filter(itemStack -> LivingEntity.m_147233_((ItemStack)itemStack).equals((Object)equipmentSlot)).findFirst();
            player.m_8061_(equipmentSlot, armorItem.orElse(ItemStack.f_41583_));
        }
    }

    private static void setHotbar(ServerPlayer player, List<ItemStack> hotbarItems) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < 9; ++i) {
            if (i < hotbarItems.size()) {
                inventory.m_6836_(i, hotbarItems.get(i));
                continue;
            }
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    private static void setFamiliar(ServerPlayer player, ResourceLocation familiarHolderId, Supplier<NetworkEvent.Context> ctx) {
        try {
            if (familiarHolderId != null) {
                new PacketSummonFamiliar(familiarHolderId).handle(ctx);
            } else {
                FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity.getOwner() != null && familiarEntity.getOwner().equals((Object)player)).stream().findFirst().ifPresent(familiarEntity -> familiarEntity.m_142687_(Entity.RemovalReason.DISCARDED));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static ResourceLocation getFamiliarId(ServerPlayer player) {
        return FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity.getOwner() != null && familiarEntity.getOwner().equals((Object)player)).stream().map(FamiliarEntity::getHolderID).findFirst().orElse(null);
    }

    private static RadialMenu<Item> getRadialMenuProvider(ArmariumStorage armariumStorage) {
        return new RadialMenu(slot -> Networking.INSTANCE.sendToServer((Object)new WizardsArmariumChoiceMessage(slot)), WizardsArmarium.getRadialMenuSlots(armariumStorage), SecondaryIconPosition.EAST, WizardsArmarium::renderItemAsNonTransparentIcon, 0);
    }

    private static List<RadialMenuSlot<Item>> getRadialMenuSlots(ArmariumStorage armariumStorage) {
        ArrayList<RadialMenuSlot<Item>> radialMenuSlots = new ArrayList<RadialMenuSlot<Item>>();
        radialMenuSlots.add(WizardsArmarium.getRadialMenuSlot(armariumStorage.getArmariumSlots().getOrDefault((Object)Slots.SLOT_ONE, new ArmariumSlot())));
        radialMenuSlots.add(WizardsArmarium.getRadialMenuSlot(armariumStorage.getArmariumSlots().getOrDefault((Object)Slots.SLOT_TWO, new ArmariumSlot())));
        radialMenuSlots.add(WizardsArmarium.getRadialMenuSlot(armariumStorage.getArmariumSlots().getOrDefault((Object)Slots.SLOT_THREE, new ArmariumSlot())));
        return radialMenuSlots;
    }

    private static RadialMenuSlot<Item> getRadialMenuSlot(ArmariumSlot armariumSlot) {
        Item primaryIcon = armariumSlot.getSpellfoci().stream().map(ItemStack::m_41720_).findFirst().orElse(null);
        List secondaryIcons = armariumSlot.getArmor().stream().map(ItemStack::m_41720_).collect(Collectors.toList());
        return new RadialMenuSlot("", (Object)primaryIcon, secondaryIcons);
    }

    public static void renderItemAsNonTransparentIcon(Item providedItem, PoseStack poseStack, int positionX, int positionY, int size, boolean renderTransparent) {
        RenderUtils.drawItemAsIcon((Item)providedItem, (PoseStack)poseStack, (int)positionX, (int)positionY, (int)size, (boolean)false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        if (world.f_46443_) {
            return super.m_7203_(world, player, handIn);
        }
        ItemStack heldArmarium = player.m_21120_(handIn);
        if (player.m_6144_()) {
            WizardsArmarium.handleModeSwitch(heldArmarium, player);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldArmarium);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)heldArmarium);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag p_77624_4_) {
        ArmariumStorage armariumStorage = new ArmariumStorage(stack);
        tooltip.addAll(armariumStorage.getTooltip());
    }
}

