/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.items.curios.armarium;

import de.sarenor.arsinstrumentum.utils.SerializationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ArmariumSlot {
    private static final String ARMARIUM_ARMOR_TAG = "ars_instrumentum_armarium_armor_tag";
    private static final String ARMARIUM_HOTBAR_TAG = "ars_instrumentum_armarium_hotbar_tag";
    private static final String ARMARIUM_SPELLFOCUS_TAG = "ars_instrumentum_armarium_spellfocus_tag";
    private static final String ARMARIUM_FAMILIAR_TAG = "ars_instrumentum_armarium_familiar_tag";
    private List<ItemStack> armor = new ArrayList<ItemStack>();
    private List<ItemStack> hotbar = new ArrayList<ItemStack>();
    private List<ItemStack> spellfoci = new ArrayList<ItemStack>();
    private ResourceLocation familiarId = new ResourceLocation("");

    public static ArmariumSlot deserialize(CompoundTag compoundTag) {
        ArmariumSlot armariumSlot = new ArmariumSlot();
        armariumSlot.setArmor(SerializationUtils.deserializeItemList(compoundTag, ARMARIUM_ARMOR_TAG));
        armariumSlot.setHotbar(SerializationUtils.deserializeItemList(compoundTag, ARMARIUM_HOTBAR_TAG));
        armariumSlot.setSpellfoci(SerializationUtils.deserializeItemList(compoundTag, ARMARIUM_SPELLFOCUS_TAG));
        if (compoundTag.m_128441_(ARMARIUM_FAMILIAR_TAG)) {
            armariumSlot.setFamiliarId(ResourceLocation.m_135820_((String)compoundTag.m_128461_(ARMARIUM_FAMILIAR_TAG)));
        }
        return armariumSlot;
    }

    public CompoundTag serialize() {
        CompoundTag serialized = new CompoundTag();
        serialized.m_128365_(ARMARIUM_ARMOR_TAG, (Tag)SerializationUtils.serializeItemList(this.armor));
        serialized.m_128365_(ARMARIUM_HOTBAR_TAG, (Tag)SerializationUtils.serializeItemList(this.hotbar));
        serialized.m_128365_(ARMARIUM_SPELLFOCUS_TAG, (Tag)SerializationUtils.serializeItemList(this.spellfoci));
        if (this.familiarId != null) {
            serialized.m_128359_(ARMARIUM_FAMILIAR_TAG, this.familiarId.toString());
        }
        return serialized;
    }

    public String listArmor() {
        return this.armor.stream().map(ItemStack::m_41611_).map(Component::getString).collect(Collectors.joining(", "));
    }

    public List<ItemStack> getArmor() {
        return this.armor;
    }

    public List<ItemStack> getHotbar() {
        return this.hotbar;
    }

    public List<ItemStack> getSpellfoci() {
        return this.spellfoci;
    }

    public ResourceLocation getFamiliarId() {
        return this.familiarId;
    }

    public void setArmor(List<ItemStack> armor) {
        this.armor = armor;
    }

    public void setHotbar(List<ItemStack> hotbar) {
        this.hotbar = hotbar;
    }

    public void setSpellfoci(List<ItemStack> spellfoci) {
        this.spellfoci = spellfoci;
    }

    public void setFamiliarId(ResourceLocation familiarId) {
        this.familiarId = familiarId;
    }
}

