/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelaySplitterTile;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import de.sarenor.arsinstrumentum.utils.BlockPosUtils;
import de.sarenor.arsinstrumentum.utils.SerializationUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RunicStorageStone
extends ModItem {
    public static final String RUNIC_STORAGE_STONE_ID = "runic_storage_stone";
    public static final String RUNIC_STORAGE_STONE_ALTERNATE_RECIPE_ID = "runic_storage_stone_alternate";
    public static final String SAVED_CONFIGURATION = "Saved Relay configuration";
    public static final String APPLIED_CONFIGURATION = "Applied Relay configuration";
    public static final String CANT_APPLY_EMPTY_CONFIGURATION = "Cannot apply empty configuration to Relay";
    public static final String CANT_APPLY_SPLITTER_CONFIGURATION_TO_ARCANE = "Cannot apply Splitter configuration to Arcane Relay";
    public static final String CANT_APPLY_ARCANE_CONFIGURATION_TO_SPLITTER = "Cannot apply Arcane configuration to Splitter Relay";
    private static final String FROM_CONFIGURATION = "from_configuration";
    private static final String TO_CONFIGURATION = "to_configuration";
    private static final String RELAY_TYPE = "relay_type";
    private static final String TOOLTIP = "tooltip";
    private static final String DIRECTION_FROM = "from_";
    private static final String DIRECTION_TO = "to_";
    private static final String RUNIC_STORAGE_STONE_TAG_ID = "scroll_of_save_starbuncle_tag";

    public RunicStorageStone() {
        super(new Item.Properties().m_41487_(1).m_41491_(ArsNouveau.itemGroup));
    }

    public static void apply(ItemStack stone, RelayTile relayTile, Player player) {
        CompoundTag stoneTag = stone.m_41784_();
        if (stoneTag.m_128441_(RUNIC_STORAGE_STONE_TAG_ID)) {
            CompoundTag configTag = stoneTag.m_128469_(RUNIC_STORAGE_STONE_TAG_ID);
            if (RelayType.valueOf(configTag.m_128461_(RELAY_TYPE)) == RelayType.SPLITTER) {
                if (relayTile instanceof RelaySplitterTile) {
                    RelaySplitterTile relaySplitterTile = (RelaySplitterTile)relayTile;
                    RunicStorageStone.applySplitterRelay(configTag, relaySplitterTile, player);
                } else if (player != null) {
                    PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)CANT_APPLY_SPLITTER_CONFIGURATION_TO_ARCANE));
                }
            } else if (!(relayTile instanceof RelaySplitterTile)) {
                RunicStorageStone.applyArcaneRelay(configTag, relayTile, player);
            } else if (player != null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)CANT_APPLY_ARCANE_CONFIGURATION_TO_SPLITTER));
            }
        } else if (player != null) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)CANT_APPLY_EMPTY_CONFIGURATION));
        }
    }

    private static void applySplitterRelay(CompoundTag configTag, RelaySplitterTile relaySplitterTile, Player player) {
        List<BlockPos> toList = SerializationUtils.deserializeBlockPosList(configTag, TO_CONFIGURATION);
        List<BlockPos> fromList = SerializationUtils.deserializeBlockPosList(configTag, FROM_CONFIGURATION);
        for (BlockPos to : toList) {
            if (relaySplitterTile.closeEnough(to)) {
                relaySplitterTile.setSendTo(to);
                continue;
            }
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)("Block " + BlockPosUtils.toString(to) + " is to far away from the Relay and could not be added to Deposit-Locations")));
        }
        for (BlockPos from : fromList) {
            if (relaySplitterTile.closeEnough(from)) {
                relaySplitterTile.setTakeFrom(from);
                continue;
            }
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)("Block " + BlockPosUtils.toString(from) + " is to far away from the Relay and could not be added to Take-Locations")));
        }
        PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)APPLIED_CONFIGURATION));
    }

    private static void applyArcaneRelay(CompoundTag configTag, RelayTile relayTile, Player player) {
        BlockPos to = SerializationUtils.deserializeBlockPos(configTag.m_128469_(TO_CONFIGURATION));
        BlockPos from = SerializationUtils.deserializeBlockPos(configTag.m_128469_(FROM_CONFIGURATION));
        if (!relayTile.closeEnough(to)) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)("Deposit-Location " + BlockPosUtils.toString(to) + " is to far away. No configuration has been applied")));
            return;
        }
        if (!relayTile.closeEnough(from)) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)("Take-Location " + BlockPosUtils.toString(from) + " is to far away. No configuration has been applied")));
            return;
        }
        relayTile.setSendTo(to);
        relayTile.setTakeFrom(from);
        PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)APPLIED_CONFIGURATION));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || context.m_43723_() == null) {
            return super.m_6225_(context);
        }
        BlockPos pos = context.m_8083_();
        Player playerEntity = context.m_43723_();
        ItemStack heldStone = context.m_43722_();
        Level world = context.m_43725_();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RelayTile) {
            RelayTile relayTile = (RelayTile)blockEntity;
            if (playerEntity.m_6144_()) {
                RunicStorageStone.apply(heldStone, relayTile, playerEntity);
            } else {
                this.store(heldStone, relayTile, playerEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag p_77624_4_) {
        CompoundTag scrollTag = stack.m_41784_();
        if (scrollTag.m_128441_(RUNIC_STORAGE_STONE_TAG_ID)) {
            tooltip.add((Component)Component.m_237113_((String)scrollTag.m_128469_(RUNIC_STORAGE_STONE_TAG_ID).m_128461_(TOOLTIP)));
        }
    }

    private void store(ItemStack stone, RelayTile relayTile, Player player) {
        if (relayTile instanceof RelaySplitterTile) {
            RelaySplitterTile relaySplitterTile = (RelaySplitterTile)relayTile;
            this.storeSplitterRelay(stone, relaySplitterTile);
        } else {
            this.storeArcaneRelay(stone, relayTile);
        }
        PortUtil.sendMessage((Entity)player, (Component)Component.m_237113_((String)SAVED_CONFIGURATION));
    }

    private void storeSplitterRelay(ItemStack stone, RelaySplitterTile relaySplitterTile) {
        CompoundTag stoneTag = stone.m_41784_();
        CompoundTag configTag = new CompoundTag();
        CompoundTag tileData = new CompoundTag();
        relaySplitterTile.m_183515_(tileData);
        List<BlockPos> fromList = this.deserializeFakeBlockList(tileData, DIRECTION_FROM);
        List<BlockPos> toList = this.deserializeFakeBlockList(tileData, DIRECTION_TO);
        configTag.m_128359_(RELAY_TYPE, RelayType.SPLITTER.name());
        configTag.m_128365_(FROM_CONFIGURATION, (Tag)SerializationUtils.serializeBlockPosList(fromList));
        configTag.m_128365_(TO_CONFIGURATION, (Tag)SerializationUtils.serializeBlockPosList(toList));
        configTag.m_128359_(TOOLTIP, "Stored Splitter Config with " + fromList.size() + " Take-Positions and " + toList.size() + " Deposit-Positions");
        stoneTag.m_128365_(RUNIC_STORAGE_STONE_TAG_ID, (Tag)configTag);
    }

    private void storeArcaneRelay(ItemStack stone, RelayTile relayTile) {
        CompoundTag stoneTag = stone.m_41784_();
        CompoundTag configTag = new CompoundTag();
        configTag.m_128365_(TO_CONFIGURATION, (Tag)SerializationUtils.serializeBlockPos(relayTile.getToPos()));
        configTag.m_128365_(FROM_CONFIGURATION, (Tag)SerializationUtils.serializeBlockPos(relayTile.getFromPos()));
        configTag.m_128359_(RELAY_TYPE, RelayType.STANDARD.name());
        configTag.m_128359_(TOOLTIP, "Stored Non-Splitter Config with Take-Position " + BlockPosUtils.toString(relayTile.getFromPos()) + " and Deposit-Position " + BlockPosUtils.toString(relayTile.getToPos()));
        stoneTag.m_128365_(RUNIC_STORAGE_STONE_TAG_ID, (Tag)configTag);
        stone.m_41751_(stoneTag);
    }

    private List<BlockPos> deserializeFakeBlockList(CompoundTag tag, String direction) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        int counter = 0;
        while (NBTUtil.hasBlockPos((CompoundTag)tag, (String)(direction + counter))) {
            BlockPos pos = NBTUtil.getBlockPos((CompoundTag)tag, (String)(direction + counter));
            if (!blockPosList.contains(pos)) {
                blockPosList.add(pos);
            }
            ++counter;
        }
        return blockPosList;
    }

    static enum RelayType {
        STANDARD,
        SPLITTER;

    }
}

