/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModColourManager;
import mob_grinding_utils.ModContainers;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModSounds;
import mob_grinding_utils.ServerResourceReloader;
import mob_grinding_utils.blocks.BlockSpikes;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.config.ServerConfig;
import mob_grinding_utils.datagen.Generator;
import mob_grinding_utils.events.BossBarHidingEvent;
import mob_grinding_utils.events.ChickenFuseEvent;
import mob_grinding_utils.events.EntityHeadDropEvent;
import mob_grinding_utils.events.EntityInteractionEvent;
import mob_grinding_utils.events.FillXPBottleEvent;
import mob_grinding_utils.events.FluidTextureStitchEvent;
import mob_grinding_utils.events.GlobalDragonSoundEvent;
import mob_grinding_utils.events.GlobalWitherSoundEvent;
import mob_grinding_utils.events.LocalDragonSoundEvent;
import mob_grinding_utils.events.LocalWitherSoundEvent;
import mob_grinding_utils.events.MGUEndermanInhibitEvent;
import mob_grinding_utils.events.MGUZombieReinforcementEvent;
import mob_grinding_utils.events.RenderChickenSwell;
import mob_grinding_utils.fakeplayer.MGUFakePlayer;
import mob_grinding_utils.inventory.client.GuiAbsorptionHopper;
import mob_grinding_utils.inventory.client.GuiFan;
import mob_grinding_utils.inventory.client.GuiMGUSpawner;
import mob_grinding_utils.inventory.client.GuiSaw;
import mob_grinding_utils.inventory.client.GuiXPSolidifier;
import mob_grinding_utils.network.MGUNetwork;
import mob_grinding_utils.network.MessageFlagSync;
import mob_grinding_utils.recipe.BeheadingRecipe;
import mob_grinding_utils.recipe.ChickenFeedRecipe;
import mob_grinding_utils.recipe.FluidIngredient;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mob_grinding_utils")
public class MobGrindingUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mob_grinding_utils");
    public static SimpleChannel NETWORK_WRAPPER;
    public static DamageSource SPIKE_DAMAGE;
    public static final DeferredRegister<ParticleType<?>> PARTICLES;
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES;
    public static final RegistryObject<SimpleParticleType> PARTICLE_FLUID_XP;
    public static final RegistryObject<RecipeSerializer<?>> CHICKEN_FEED;
    public static final List<SolidifyRecipe> SOLIDIFIER_RECIPES;
    public static final List<BeheadingRecipe> BEHEADING_RECIPES;
    public static final RegistryObject<RecipeSerializer<?>> SOLIDIFIER_RECIPE;
    public static final RegistryObject<RecipeSerializer<?>> BEHEADING_RECIPE;
    public static final RegistryObject<RecipeType<SolidifyRecipe>> SOLIDIFIER_TYPE;
    public static final RegistryObject<RecipeType<BeheadingRecipe>> BEHEADING_TYPE;
    public static final CreativeModeTab TAB;

    public MobGrindingUtils() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.init(modBus);
        ModItems.init(modBus);
        ModContainers.init(modBus);
        PARTICLES.register(modBus);
        RECIPES.register(modBus);
        RECIPE_TYPES.register(modBus);
        ModSounds.init(modBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ModelLayers.init(modBus));
        modBus.addListener(this::setup);
        modBus.addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        MinecraftForge.EVENT_BUS.addListener(BlockSpikes::dropXP);
        MinecraftForge.EVENT_BUS.register((Object)new EntityInteractionEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ChickenFuseEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LocalWitherSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LocalDragonSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntityHeadDropEvent());
        MinecraftForge.EVENT_BUS.register((Object)new MGUZombieReinforcementEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FillXPBottleEvent());
        MinecraftForge.EVENT_BUS.register((Object)new MGUEndermanInhibitEvent());
        MinecraftForge.EVENT_BUS.addListener(this::playerConnected);
        MinecraftForge.EVENT_BUS.addListener(this::changedDimension);
        MinecraftForge.EVENT_BUS.addListener(this::playerRespawn);
        MinecraftForge.EVENT_BUS.addListener(this::cloneEvent);
        MinecraftForge.EVENT_BUS.addListener(this::serverReloadListener);
        MinecraftForge.EVENT_BUS.addListener(this::clientRecipeReload);
        modBus.addListener(Generator::gatherData);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)FluidIngredient.Serializer.NAME, (IIngredientSerializer)FluidIngredient.SERIALIZER));
        SPIKE_DAMAGE = new DamageSource("spikes").m_19380_();
        NETWORK_WRAPPER = MGUNetwork.getNetworkChannel();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FluidTextureStitchEvent());
        MinecraftForge.EVENT_BUS.register((Object)new RenderChickenSwell());
        MinecraftForge.EVENT_BUS.register((Object)new GlobalWitherSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new GlobalDragonSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BossBarHidingEvent());
        MinecraftForge.EVENT_BUS.addListener(this::worldUnload);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.ABSORPTION_HOPPER.get()), GuiAbsorptionHopper::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.SOLIDIFIER.get()), GuiXPSolidifier::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.FAN.get()), GuiFan::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.SAW.get()), GuiSaw::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.ENTITY_SPAWNER.get()), GuiMGUSpawner::new);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModBlocks.FLUID_XP_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModBlocks.FLUID_XP.get()), (RenderType)RenderType.m_110466_());
        event.enqueueWork(ModColourManager::registerColourHandlers);
    }

    private void serverReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ServerResourceReloader(event.getServerResources()));
    }

    private void clientRecipeReload(RecipesUpdatedEvent event) {
        SOLIDIFIER_RECIPES.clear();
        SOLIDIFIER_RECIPES.addAll(event.getRecipeManager().m_44013_((RecipeType)SOLIDIFIER_TYPE.get()));
    }

    private void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendPersistentData((ServerPlayer)event.getEntity());
        }
    }

    private void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendPersistentData((ServerPlayer)event.getEntity());
        }
    }

    private void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendPersistentData((ServerPlayer)event.getEntity());
        }
    }

    private void sendPersistentData(ServerPlayer playerEntity) {
        CompoundTag nbt = playerEntity.getPersistentData();
        if (nbt.m_128441_("MGU_WitherMuffle") || nbt.m_128441_("MGU_DragonMuffle")) {
            NETWORK_WRAPPER.send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)new MessageFlagSync(nbt.m_128471_("MGU_WitherMuffle"), nbt.m_128471_("MGU_DragonMuffle")));
        }
    }

    private void cloneEvent(PlayerEvent.Clone event) {
        CompoundTag nbt = event.getOriginal().getPersistentData();
        if (nbt.m_128441_("MGU_WitherMuffle") || nbt.m_128441_("MGU_DragonMuffle")) {
            CompoundTag newNBT = event.getEntity().getPersistentData();
            newNBT.m_128379_("MGU_WitherMuffle", nbt.m_128471_("MGU_WitherMuffle"));
            newNBT.m_128379_("MGU_DragonMuffle", nbt.m_128471_("MGU_DragonMuffle"));
        }
    }

    private void worldUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            MGUFakePlayer.unload(event.getLevel());
        }
    }

    static {
        PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"mob_grinding_utils");
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"mob_grinding_utils");
        RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registry.f_122914_, (String)"mob_grinding_utils");
        PARTICLE_FLUID_XP = PARTICLES.register("fluid_xp_particles", () -> new SimpleParticleType(true));
        CHICKEN_FEED = RECIPES.register("chicken_feed", ChickenFeedRecipe.Serializer::new);
        SOLIDIFIER_RECIPES = new ArrayList<SolidifyRecipe>();
        BEHEADING_RECIPES = new ArrayList<BeheadingRecipe>();
        SOLIDIFIER_RECIPE = RECIPES.register("solidify", SolidifyRecipe.Serializer::new);
        BEHEADING_RECIPE = RECIPES.register("beheading", BeheadingRecipe.Serializer::new);
        SOLIDIFIER_TYPE = RECIPE_TYPES.register("solidify", () -> new RecipeType<SolidifyRecipe>(){});
        BEHEADING_TYPE = RECIPE_TYPES.register("beheading", () -> new RecipeType<BeheadingRecipe>(){});
        TAB = new CreativeModeTab("mob_grinding_utils"){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ModBlocks.SPIKES.getItem());
            }
        };
    }
}

