/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemInstance;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.TypeKeyed;

public class GemItem
extends Item {
    public static final String HAS_REFRESHED = "has_refreshed";
    public static final String UUID_ARRAY = "uuids";
    public static final String GEM = "gem";

    public GemItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            tooltip.add((Component)Component.m_237113_((String)"Errored gem with no bonus!").m_130940_(ChatFormatting.GRAY));
            return;
        }
        inst.gem().addInformation(pStack, GemItem.getLootRarity(pStack), tooltip::add);
    }

    public Component m_7626_(ItemStack pStack) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            return super.m_7626_(pStack);
        }
        MutableComponent comp = Component.m_237115_((String)this.m_5671_(pStack));
        comp = Component.m_237110_((String)("item.apotheosis.gem." + inst.rarity().id()), (Object[])new Object[]{comp});
        return comp.m_130948_(Style.f_131099_.m_131148_(inst.rarity().color()));
    }

    public String m_5671_(ItemStack pStack) {
        Gem gem = GemItem.getGem(pStack);
        if (gem == null) {
            return super.m_5524_();
        }
        return super.m_5671_(pStack) + "." + gem.getId();
    }

    public boolean m_5812_(ItemStack pStack) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            return super.m_5812_(pStack);
        }
        return inst.isMaxRarity();
    }

    public boolean m_41386_(DamageSource src) {
        return super.m_41386_(src) && src != DamageSource.f_19321_;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == CreativeModeTab.f_40754_) {
            GemManager.INSTANCE.getValues().stream().sorted(Comparator.comparing(TypeKeyed.TypeKeyedBase::getId)).forEach(gem -> {
                for (LootRarity rarity : LootRarity.values()) {
                    if (gem.clamp(rarity) != rarity) continue;
                    ItemStack stack = new ItemStack((ItemLike)this);
                    GemItem.setGem(stack, gem);
                    GemItem.setLootRarity(stack, rarity);
                    items.add((Object)stack);
                }
            });
        }
    }

    public void m_6883_(ItemStack stack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(UUID_ARRAY);
            tag.m_128473_("facets");
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        GemInstance inst = GemInstance.unsocketed(stack);
        if (inst.isValidUnsocketed()) {
            return inst.gem().getId().m_135827_();
        }
        return super.getCreatorModId(stack);
    }

    public static List<UUID> getUUIDs(ItemStack gemStack) {
        Gem gem = GemItem.getGem(gemStack);
        if (gem == null) {
            return Collections.emptyList();
        }
        return GemItem.getOrCreateUUIDs(gemStack.m_41784_(), gem.getNumberOfUUIDs());
    }

    public static List<UUID> getOrCreateUUIDs(CompoundTag tag, int numUUIDs) {
        if (numUUIDs == 0) {
            return Collections.emptyList();
        }
        if (tag.m_128441_(UUID_ARRAY)) {
            ListTag list = tag.m_128437_(UUID_ARRAY, 11);
            ArrayList<UUID> ret = new ArrayList<UUID>(list.size());
            for (Tag t : list) {
                ret.add(NbtUtils.m_129233_((Tag)t));
            }
            if (ret.size() < numUUIDs) {
                return GemItem.generateAndSave(ret, numUUIDs, tag);
            }
            return ret;
        }
        return GemItem.generateAndSave(new ArrayList<UUID>(numUUIDs), numUUIDs, tag);
    }

    private static List<UUID> generateAndSave(List<UUID> base, int amount, CompoundTag tag) {
        int needed = amount - base.size();
        for (int i = 0; i < needed; ++i) {
            base.add(UUID.randomUUID());
        }
        ListTag list = new ListTag();
        for (UUID id : base) {
            list.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        tag.m_128365_(UUID_ARRAY, (Tag)list);
        return base;
    }

    public static void setGem(ItemStack gemStack, Gem gem) {
        gemStack.m_41784_().m_128359_(GEM, gem.getId().toString());
    }

    @Nullable
    public static Gem getGem(ItemStack gem) {
        if (gem.m_41720_() != Apoth.Items.GEM.get() || !gem.m_41782_()) {
            return null;
        }
        CompoundTag tag = gem.m_41783_();
        if (tag.m_128441_(GEM)) {
            return (Gem)GemManager.INSTANCE.getValue(new ResourceLocation(tag.m_128461_(GEM)));
        }
        return null;
    }

    public static void setLootRarity(ItemStack stack, LootRarity rarity) {
        stack.m_41784_().m_128359_("rarity", rarity.id());
    }

    @Nullable
    public static LootRarity getLootRarity(ItemStack stack) {
        Gem gem = GemItem.getGem(stack);
        return gem == null ? null : gem.clamp(AffixHelper.getRarity(stack.m_41783_()));
    }
}

