/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.PhaseTools;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.rules.RuleBase;
import mcjty.incontrol.tools.typed.Attribute;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.typed.GenericAttributeMapFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class SpecialRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<LivingSpawnEvent.SpecialSpawn> EVENT_QUERY = new IEventQuery<LivingSpawnEvent.SpecialSpawn>(){

        @Override
        public LevelAccessor getWorld(LivingSpawnEvent.SpecialSpawn o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(LivingSpawnEvent.SpecialSpawn o) {
            return new BlockPos(o.getX(), o.getY(), o.getZ());
        }

        @Override
        public BlockPos getValidBlockPos(LivingSpawnEvent.SpecialSpawn o) {
            return new BlockPos(o.getX(), o.getY() - 1.0, o.getZ());
        }

        @Override
        public int getY(LivingSpawnEvent.SpecialSpawn o) {
            return (int)o.getY();
        }

        @Override
        public Entity getEntity(LivingSpawnEvent.SpecialSpawn o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(LivingSpawnEvent.SpecialSpawn o) {
            return null;
        }

        @Override
        public Entity getAttacker(LivingSpawnEvent.SpecialSpawn o) {
            return null;
        }

        @Override
        public Player getPlayer(LivingSpawnEvent.SpecialSpawn o) {
            return SpecialRule.getClosestPlayer(o.getLevel(), new BlockPos(o.getX(), o.getY(), o.getZ()));
        }

        @Override
        public ItemStack getItem(LivingSpawnEvent.SpecialSpawn o) {
            return ItemStack.f_41583_;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private final GenericRuleEvaluator ruleEvaluator;
    private final Set<String> phases;
    private final int index;
    private SpecialResult result = SpecialResult.AFTER;
    private boolean doContinue = false;

    private static Player getClosestPlayer(LevelAccessor world, BlockPos pos) {
        return world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 100.0, false);
    }

    private SpecialRule(AttributeMap map, Set<String> phases, int index) {
        super(InControl.setup.getLogger());
        this.phases = phases;
        this.index = index;
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer(), index);
        if (!map.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            map.getKeys().forEach(k -> buffer.append(k).append(' '));
            ErrorHandler.error("Invalid keywords in special rule: " + buffer);
        }
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public static SpecialRule parse(JsonElement element, int index) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element, "spawn.json");
        return new SpecialRule(map, PhaseTools.getPhases(element), index);
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer, int index) {
        super.addActions(map, layer, index);
        map.consumeOrElse(RuleKeys.ACTION_RESULT, br -> {
            this.result = "before".equals(br) ? SpecialResult.BEFORE : ("replace".equals(br) ? SpecialResult.REPLACE : SpecialResult.AFTER);
        }, () -> {
            this.result = SpecialResult.AFTER;
        });
        map.consume(RuleKeys.ACTION_CONTINUE, v -> {
            this.doContinue = v;
        });
    }

    public boolean match(LivingSpawnEvent.SpecialSpawn event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    public void action(final LivingSpawnEvent.SpecialSpawn event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity();
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            @Override
            public LevelAccessor getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getEntity().m_20183_();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    @Nonnull
    public SpecialResult getResult() {
        return this.result;
    }

    public boolean isDoContinue() {
        return this.doContinue;
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.PHASE)).attribute(Attribute.create(RuleKeys.TIME)).attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.DAYCOUNT)).attribute(Attribute.create(RuleKeys.MINDAYCOUNT)).attribute(Attribute.create(RuleKeys.MAXDAYCOUNT)).attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create(RuleKeys.LIGHT)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINLIGHT_FULL)).attribute(Attribute.create(RuleKeys.MAXLIGHT_FULL)).attribute(Attribute.create(RuleKeys.HEIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.CANSPAWNHERE)).attribute(Attribute.create(RuleKeys.NOTCOLLIDING)).attribute(Attribute.create(RuleKeys.SPAWNER)).attribute(Attribute.create(RuleKeys.INCONTROL)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.createMulti(RuleKeys.BUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.GAMESTAGE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create(RuleKeys.BABY)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.SLIME)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.BIOMETAGS)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.HASSTRUCTURE)).attribute(Attribute.createMulti(RuleKeys.STRUCTURE)).attribute(Attribute.createMulti(RuleKeys.STRUCTURETAGS)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ALL)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ANY)).attribute(Attribute.createMulti(RuleKeys.HELMET)).attribute(Attribute.createMulti(RuleKeys.CHESTPLATE)).attribute(Attribute.createMulti(RuleKeys.LEGGINGS)).attribute(Attribute.createMulti(RuleKeys.BOOTS)).attribute(Attribute.createMulti(RuleKeys.AMULET)).attribute(Attribute.createMulti(RuleKeys.RING)).attribute(Attribute.createMulti(RuleKeys.BELT)).attribute(Attribute.createMulti(RuleKeys.TRINKET)).attribute(Attribute.createMulti(RuleKeys.HEAD)).attribute(Attribute.createMulti(RuleKeys.BODY)).attribute(Attribute.createMulti(RuleKeys.CHARM)).attribute(Attribute.createMulti(RuleKeys.PLAYER_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti(RuleKeys.BOTHHANDSITEM)).attribute(Attribute.create(RuleKeys.ACTION_CONTINUE)).attribute(Attribute.create(RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHSET)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHADD)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDSET)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGESET)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEADD)).attribute(Attribute.create(RuleKeys.ACTION_ARMORSET)).attribute(Attribute.create(RuleKeys.ACTION_ARMORMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ARMORADD)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSSET)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSADD)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDSET)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGESET)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGEADD)).attribute(Attribute.create(RuleKeys.ACTION_SIZEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SIZEADD)).attribute(Attribute.create(RuleKeys.ACTION_ANGRY)).attribute(Attribute.create(RuleKeys.ACTION_MOBNBT)).attribute(Attribute.create(RuleKeys.ACTION_CUSTOMNAME)).attribute(Attribute.createMulti(RuleKeys.ACTION_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORBOOTS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORLEGS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORCHEST)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORHELMET)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION)).attribute(Attribute.create(RuleKeys.ACTION_NODESPAWN));
    }

    public static enum SpecialResult {
        BEFORE,
        AFTER,
        REPLACE;

    }
}

