/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.data;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.incontrol.rules.PhaseRule;
import mcjty.incontrol.rules.RulesManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DataStorage
extends SavedData {
    private static final String NAME = "InControlData";
    private Boolean isDay = null;
    private int daycounter = 0;
    private final Set<String> phases = new HashSet<String>();
    private int checkCounter = 0;

    public DataStorage() {
    }

    public DataStorage(CompoundTag tag) {
        this.daycounter = tag.m_128451_("daycounter");
        this.isDay = tag.m_128441_("isday") ? Boolean.valueOf(tag.m_128471_("isday")) : null;
    }

    @Nonnull
    public static DataStorage getData(Level world) {
        if (world.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        MinecraftServer server = world.m_7654_();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (DataStorage)storage.m_164861_(DataStorage::new, DataStorage::new, NAME);
    }

    public int getDaycounter() {
        return this.daycounter;
    }

    public void setDaycounter(int daycounter) {
        this.daycounter = daycounter;
        this.m_77762_();
    }

    public Boolean getDay() {
        return this.isDay;
    }

    public void setDay(Boolean day) {
        this.isDay = day;
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public void tick(Level world) {
        this.tickTime(world);
        --this.checkCounter;
        if (this.checkCounter <= 0) {
            this.checkCounter = 10;
            this.tickPhases(world);
        }
    }

    private void tickTime(Level world) {
        boolean day;
        long time = world.m_46468_() % 24000L;
        boolean bl = day = time >= 0L && time < 12000L;
        if (this.isDay == null) {
            this.isDay = day;
            this.m_77762_();
        } else if (day != this.isDay) {
            if (day) {
                ++this.daycounter;
            }
            this.isDay = day;
            this.m_77762_();
        }
    }

    private void tickPhases(Level world) {
        boolean dirty = false;
        for (PhaseRule rule : RulesManager.phaseRules) {
            if (rule.match((LevelAccessor)world)) {
                if (!this.phases.add(rule.getName())) continue;
                dirty = true;
                continue;
            }
            if (!this.phases.remove(rule.getName())) continue;
            dirty = true;
        }
        if (dirty) {
            RulesManager.onPhaseChange();
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("daycounter", this.daycounter);
        if (this.isDay != null) {
            tag.m_128379_("isday", this.isDay.booleanValue());
        }
        return tag;
    }
}

