/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import mcjty.incontrol.InControl;
import mcjty.incontrol.commands.CmdList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class CmdKillMobs
implements Command<CommandSourceStack> {
    private static final CmdKillMobs CMD = new CmdKillMobs();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"kill").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String type = (String)context.getArgument("type", String.class);
        if (type == null || type.trim().isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Use 'all', 'passive', 'hostile' or name of the mob followed by optional dimension id")));
            InControl.setup.getLogger().error("Use 'all', 'passive', 'hostile', 'entity' or name of the mob followed by optional dimension id");
            return 0;
        }
        ResourceKey dimension = player.m_20193_().m_46472_();
        boolean all = "all".equals(type);
        boolean passive = "passive".equals(type);
        boolean hostile = "hostile".equals(type);
        boolean entity = "entity".equals(type);
        ServerLevel worldServer = player.m_20193_().m_7654_().m_129880_(dimension);
        List entities = worldServer.m_143280_(CmdList.ANY_TYPE, input -> {
            if (all) {
                return !(input instanceof Player);
            }
            if (passive) {
                return input instanceof Animal && !(input instanceof Enemy);
            }
            if (hostile) {
                return input instanceof Enemy;
            }
            if (entity) {
                return !(input instanceof Animal) && !(input instanceof Player);
            }
            String id = ForgeRegistries.ENTITY_TYPES.getKey((Object)input.m_6095_()).toString();
            return type.equals(id);
        });
        for (Entity e : entities) {
            e.m_142467_(Entity.RemovalReason.KILLED);
        }
        player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + "Removed " + entities.size() + " entities!")));
        return 0;
    }
}

