/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.net;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.net.Message;
import de.maxhenkel.pipez.gui.ExtractContainer;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class RemoveFilterMessage
implements Message<RemoveFilterMessage> {
    private UUID filter;
    private int index;

    public RemoveFilterMessage() {
    }

    public RemoveFilterMessage(UUID filter, int index) {
        this.filter = filter;
        this.index = index;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        AbstractContainerMenu container = context.getSender().f_36096_;
        if (container instanceof ExtractContainer) {
            ExtractContainer extractContainer = (ExtractContainer)container;
            PipeType<?> pipeType = extractContainer.getPipe().getPipeTypes()[this.index];
            List<Filter<?>> filters = extractContainer.getPipe().getFilters(extractContainer.getSide(), pipeType);
            filters.removeIf(f -> f.getId().equals(this.filter));
            extractContainer.getPipe().setFilters(extractContainer.getSide(), pipeType, filters);
        }
    }

    @Override
    public RemoveFilterMessage fromBytes(FriendlyByteBuf packetBuffer) {
        this.filter = packetBuffer.m_130259_();
        this.index = packetBuffer.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(this.filter);
        packetBuffer.writeInt(this.index);
    }
}

