/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import net.minecraft.world.level.Level;

public class TimeTracker {
    private long lastMark = Long.MIN_VALUE;
    private static EmptyTimeTracker EMPTY;

    public boolean hasDelayPassed(Level world, int delay) {
        long currentTime = world.m_46467_();
        if (currentTime < this.lastMark) {
            this.lastMark = currentTime;
            return false;
        }
        if (this.lastMark + (long)delay <= currentTime) {
            this.lastMark = currentTime;
            return true;
        }
        return false;
    }

    public void markTime(Level world) {
        this.lastMark = world.m_46467_();
    }

    public boolean notSet() {
        return this.lastMark == Long.MIN_VALUE;
    }

    public static TimeTracker empty() {
        if (EMPTY == null) {
            EMPTY = new EmptyTimeTracker();
        }
        return EMPTY;
    }

    private static class EmptyTimeTracker
    extends TimeTracker {
        private EmptyTimeTracker() {
        }

        @Override
        public boolean hasDelayPassed(Level world, int delay) {
            return false;
        }

        @Override
        public void markTime(Level world) {
        }

        @Override
        public boolean notSet() {
            return true;
        }
    }
}

