/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.entity.IOnPlaced;
import cofh.core.item.ItemCoFH;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoatItemCoFH
extends ItemCoFH {
    protected static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    protected final Supplier<EntityType<? extends Boat>> type;
    protected final IBoatFactory<? extends Boat> factory;
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = source.m_7727_();
            double d0 = source.m_7096_() + (double)direction.m_122429_() * 1.125;
            double d1 = source.m_7098_() + (double)direction.m_122430_() * 1.125;
            double d2 = source.m_7094_() + (double)direction.m_122431_() * 1.125;
            BlockPos pos = source.m_7961_().m_121945_(direction);
            Item item = stack.m_41720_();
            if (item instanceof BoatItemCoFH) {
                double d3;
                BoatItemCoFH boatItem = (BoatItemCoFH)item;
                Boat boat = boatItem.createBoat(stack, (Level)level, direction.m_122435_(), d0, d1, d2);
                if (boat.canBoatInFluid(level.m_6425_(pos))) {
                    d3 = 1.0;
                } else {
                    if (!level.m_8055_(pos).m_60795_() || !boat.canBoatInFluid(level.m_6425_(pos.m_7495_()))) {
                        return this.behaviourDefaultDispenseItem.m_6115_(source, stack);
                    }
                    d3 = 0.0;
                }
                boat.m_6034_(d0, d1 + d3, d2);
                level.m_7967_((Entity)boat);
                stack.m_41774_(1);
                return stack;
            }
            return ItemStack.f_41583_;
        }
    };

    public BoatItemCoFH(Supplier<EntityType<? extends Boat>> type, IBoatFactory<? extends Boat> factory, Item.Properties builder) {
        super(builder);
        this.type = type;
        this.factory = factory;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitresult = BoatItemCoFH.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        Vec3 vec3 = player.m_20252_(1.0f);
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            Boat boat = this.createBoat(stack, level, player.m_146908_(), hitresult.m_82450_().f_82479_, hitresult.m_82450_().f_82480_, hitresult.m_82450_().f_82481_);
            if (!level.m_45756_((Entity)boat, boat.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)boat);
                level.m_220400_((Entity)player, GameEvent.f_157810_, hitresult.m_82450_());
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected Boat createBoat(ItemStack stack, Level level, float rotation, double posX, double posY, double posZ) {
        Boat boat = this.factory.createBoat(this.type, level, posX, posY, posZ);
        if (stack.m_41788_()) {
            boat.m_6593_(stack.m_41786_());
        }
        if (boat instanceof IOnPlaced) {
            IOnPlaced placedBoat = (IOnPlaced)boat;
            placedBoat.onPlaced(stack);
        }
        boat.m_146922_(rotation);
        return boat;
    }

    public static interface IBoatFactory<T extends Boat> {
        public T createBoat(Supplier<EntityType<? extends Boat>> var1, Level var2, double var3, double var5, double var7);
    }
}

