/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.ColorParticle;
import cofh.core.client.particle.options.CylindricalParticleOptions;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class CylindricalParticle
extends ColorParticle {
    public float height;
    public Quaternion rotation = Quaternion.f_80118_;

    public CylindricalParticle(CylindricalParticleOptions data, ClientLevel level, double x, double y, double z) {
        super(data, level, x, y, z, 0.0, 0.0, 0.0);
        this.setHeight(data.height);
        this.recalcBB();
        this.f_107219_ = false;
    }

    public CylindricalParticle(CylindricalParticleOptions data, ClientLevel level, double x, double y, double z, double xDir, double yDir, double zDir) {
        super(data, level, x, y, z, 0.0, 0.0, 0.0);
        this.setHeight(data.height);
        this.setDirection(xDir, yDir, zDir);
        this.recalcBB(xDir, yDir, zDir);
        this.f_107219_ = false;
    }

    protected void setHeight(float height) {
        this.height = height;
    }

    protected void setDirection(double xDir, double yDir, double zDir) {
        this.setDirection(new Vec3(xDir, yDir, zDir));
    }

    protected void setDirection(Vec3 direction) {
        this.rotation = VFXHelper.alignVertical(new Vector3f(direction));
    }

    protected void recalcBB(double xDir, double yDir, double zDir) {
        float xc = (float)xDir;
        float yc = (float)yDir;
        float zc = (float)zDir;
        float[] fArray = new float[]{xc, yc, zc};
        float distSqr = MathHelper.distSqr(fArray);
        if ((double)distSqr < 1.0E-4) {
            this.recalcBB();
            return;
        }
        float invLen = 1.0f / MathHelper.sqrt(distSqr);
        float xl = this.height * (xc *= invLen) + this.size * MathHelper.sqrt(1.0f - xc * xc);
        float yl = this.height * (yc *= invLen) + this.size * MathHelper.sqrt(1.0f - yc * yc);
        float zl = this.height * (zc *= invLen) + this.size * MathHelper.sqrt(1.0f - zc * zc);
        Vec3 pos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        this.m_107259_(new AABB(pos, pos).m_82377_((double)(xl * 0.5f), (double)(yl * 0.5f), (double)(zl * 0.5f)));
        this.f_107221_ = Math.max(xl, zl);
        this.f_107222_ = yl;
    }

    protected void recalcBB() {
        float radius = this.size * 0.5f;
        Vec3 pos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        this.m_107259_(new AABB(pos, pos).m_82377_((double)radius, (double)(this.height * 0.5f), (double)radius));
        this.f_107221_ = this.size;
        this.f_107222_ = this.height;
    }
}

