/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.panel.PanelTracker;
import cofh.core.util.helpers.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class PanelBase
extends ElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE_LEFT = new ResourceLocation("cofh_core:textures/gui/elements/panel_left.png");
    public static final ResourceLocation DEFAULT_TEXTURE_RIGHT = new ResourceLocation("cofh_core:textures/gui/elements/panel_right.png");
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static int panelExpandSpeed = 8;
    public boolean open;
    protected boolean fullyOpen;
    public int side;
    protected int headerColor = 14797103;
    protected int subheaderColor = 11186104;
    protected int textColor = 0;
    protected int backgroundColor = 0xFFFFFF;
    protected int shiftX = 0;
    protected int shiftY = 0;
    protected int mX = 0;
    protected int mY = 0;
    protected int minWidth = 22;
    protected int maxWidth = 100;
    protected int minHeight = 22;
    protected int maxHeight = 92;
    private final ArrayList<ElementBase> elements = new ArrayList();

    public PanelBase(IGuiAccess gui) {
        this(gui, 1);
    }

    public PanelBase(IGuiAccess gui, int sideIn) {
        super(gui);
        this.side = sideIn;
        this.width = this.minWidth;
        this.height = this.minHeight;
        this.texture = this.side == 0 ? DEFAULT_TEXTURE_LEFT : DEFAULT_TEXTURE_RIGHT;
    }

    public PanelBase setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public boolean intersectsWith(double mouseX, double mouseY, int shiftX, int shiftY) {
        if (this.side == 0) {
            return mouseX <= (double)shiftX && mouseX >= (double)(shiftX - this.width) && mouseY >= (double)shiftY && mouseY <= (double)(shiftY + this.height);
        }
        return mouseX >= (double)shiftX && mouseX <= (double)(shiftX + this.width) && mouseY >= (double)shiftY && mouseY <= (double)(shiftY + this.height);
    }

    protected void drawPanelIcon(PoseStack matrixStack, TextureAtlasSprite iconName) {
        this.gui.drawIcon(matrixStack, iconName, this.sideOffset(), 3);
    }

    protected void drawForeground(PoseStack matrixStack) {
    }

    protected void drawBackground(PoseStack matrixStack) {
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        RenderHelper.setShaderTexture0(this.texture);
        this.gui.drawTexturedModalRect(matrixStack, 0, 4, 0, 256 - this.height + 4, 4, this.height - 4);
        this.gui.drawTexturedModalRect(matrixStack, 4, 0, 256 - this.width + 4, 0, this.width - 4, 4);
        this.gui.drawTexturedModalRect(matrixStack, 0, 0, 0, 0, 4, 4);
        this.gui.drawTexturedModalRect(matrixStack, 4, 4, 256 - this.width + 4, 256 - this.height + 4, this.width - 4, this.height - 4);
        RenderHelper.resetShaderColor();
    }

    @Override
    public void drawBackground(PoseStack matrixStack, int mouseX, int mouseY) {
        mouseX -= this.posX();
        mouseY -= this.posY();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.posX(), (double)this.posY(), 0.0);
        this.drawBackground(matrixStack);
        if (this.fullyOpen) {
            for (ElementBase element : this.elements) {
                if (!element.visible()) continue;
                element.drawBackground(matrixStack, mouseX, mouseY);
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    public void drawForeground(PoseStack matrixStack, int mouseX, int mouseY) {
        mouseX -= this.posX();
        mouseY -= this.posY();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.posX(), (double)this.posY(), 0.0);
        this.drawForeground(matrixStack);
        if (this.fullyOpen) {
            for (ElementBase element : this.elements) {
                if (!element.visible()) continue;
                element.drawForeground(matrixStack, mouseX, mouseY);
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        tooltipList.addAll(this.tooltip.create(this, mouseX, mouseY));
        mouseX -= this.posX();
        mouseY -= this.posY();
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.intersectsWith(mouseX, mouseY)) continue;
            c.addTooltip(tooltipList, mouseX, mouseY);
        }
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        this.mX = mouseX - this.posX();
        this.mY = mouseY - this.posY();
        this.updateElements();
    }

    public void setShift(int x, int y) {
        this.updateElements();
        this.shiftX = x;
        this.shiftY = y;
    }

    public void updateSize() {
        if (this.open && this.width < this.maxWidth) {
            this.width += panelExpandSpeed;
        } else if (!this.open && this.width > this.minWidth) {
            this.width -= panelExpandSpeed;
        }
        if (this.width > this.maxWidth) {
            this.width = this.maxWidth;
        } else if (this.width < this.minWidth) {
            this.width = this.minWidth;
        }
        if (this.open && this.height < this.maxHeight) {
            this.height += panelExpandSpeed;
        } else if (!this.open && this.height > this.minHeight) {
            this.height -= panelExpandSpeed;
        }
        if (this.height > this.maxHeight) {
            this.height = this.maxHeight;
        } else if (this.height < this.minHeight) {
            this.height = this.minHeight;
        }
        if (!this.fullyOpen && this.open && this.width == this.maxWidth && this.height == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    public void setFullyOpen() {
        this.open = true;
        this.fullyOpen = true;
        this.width = this.maxWidth;
        this.height = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            this.fullyOpen = false;
            if (this.side == 0) {
                PanelTracker.setOpenedLeft(null);
            } else {
                PanelTracker.setOpenedRight(null);
            }
        } else {
            this.open = true;
            if (this.side == 0) {
                PanelTracker.setOpenedLeft(this.getClass());
            } else {
                PanelTracker.setOpenedRight(this.getClass());
            }
        }
    }

    protected final void updateElements() {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.update(this.mX, this.mY);
        }
    }

    public final Rect2i getBoundsOnScreen() {
        return new Rect2i(this.posX() + this.guiLeft(), this.posY() + this.guiTop(), this.visible() ? this.width : 0, this.visible() ? this.height : 0);
    }

    protected <T> T addElement(ElementBase element) {
        this.elements.add(element.setVisible(() -> this.fullyOpen).setOffsets(this::posX, () -> this.posY()));
        return (T)element;
    }

    @Override
    public int posX() {
        return this.side == 0 ? super.posX() - this.width : super.posX();
    }

    protected int sideOffset() {
        return this.side == 0 ? 4 : 2;
    }

    @Override
    public boolean keyTyped(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.keyTyped(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return super.keyTyped(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        mouseX -= (double)this.posX();
        mouseY -= (double)this.posY();
        boolean shouldStayOpen = false;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.intersectsWith(mouseX, mouseY)) continue;
            shouldStayOpen = true;
            if (!c.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return shouldStayOpen;
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY) {
        mouseX -= (double)this.posX();
        mouseY -= (double)this.posY();
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.mouseReleased(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseWheel(double mouseX, double mouseY, double movement) {
        mouseX -= (double)this.posX();
        mouseY -= (double)this.posY();
        if (movement != 0.0) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.visible() || !c.enabled() || !c.intersectsWith(mouseX, mouseY) || !c.mouseWheel(mouseX, mouseY, movement)) continue;
                return true;
            }
        }
        return true;
    }
}

