/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementConditionalLayered;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.api.control.IReconfigurable;
import cofh.lib.api.control.ITransferControllable;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;

public class ConfigPanel
extends PanelBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0x101010;
    public static int defaultBackgroundColor = 0x226688;
    private final IReconfigurable myReconfig;
    private final ITransferControllable myTransfer;
    private final Supplier<Direction> myFacing;
    private boolean allowFacingConfig = false;

    public ConfigPanel(IGuiAccess gui, IReconfigurable reconfig, Supplier<Direction> facingSup) {
        this(gui, defaultSide, null, reconfig, facingSup);
    }

    public ConfigPanel(IGuiAccess gui, ITransferControllable transfer, IReconfigurable reconfig, Supplier<Direction> facingSup) {
        this(gui, defaultSide, transfer, reconfig, facingSup);
    }

    protected ConfigPanel(IGuiAccess gui, int sideIn, ITransferControllable transfer, IReconfigurable reconfig, Supplier<Direction> facingSup) {
        super(gui, sideIn);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = transfer == null ? 100 : 112;
        this.myReconfig = reconfig;
        this.myTransfer = transfer;
        this.myFacing = facingSup;
        this.setVisible(this.myReconfig::isReconfigurable);
    }

    public ConfigPanel allowFacingConfig(boolean allowFacingConfig) {
        this.allowFacingConfig = allowFacingConfig;
        return this;
    }

    public ConfigPanel addConditionals(ElementConditionalLayered ... c) {
        if (c.length != 6) {
            return this;
        }
        int xOffset = this.myTransfer != null ? 12 : 0;
        c[0].setPosition(40 + xOffset, 24);
        c[1].setPosition(20 + xOffset, 44);
        c[2].setPosition(40 + xOffset, 44);
        c[3].setPosition(60 + xOffset, 44);
        c[4].setPosition(40 + xOffset, 64);
        c[5].setPosition(60 + xOffset, 64);
        for (int i = 0; i < 6; ++i) {
            this.addElement(c[i]);
        }
        return this;
    }

    @Override
    protected void drawForeground(PoseStack matrixStack) {
        this.drawPanelIcon(matrixStack, CoreTextures.ICON_CONFIG);
        if (!this.fullyOpen) {
            return;
        }
        this.fontRenderer().m_92750_(matrixStack, StringHelper.localize("info.cofh.configuration"), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        if (this.myTransfer != null) {
            if (this.myTransfer.hasTransferIn()) {
                this.gui.drawIcon(matrixStack, this.myTransfer.getTransferIn() ? CoreTextures.ICON_BUTTON_HIGHLIGHT : CoreTextures.ICON_BUTTON, 8, 34);
            } else {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_INACTIVE, 8, 34);
            }
            if (this.myTransfer.hasTransferOut()) {
                this.gui.drawIcon(matrixStack, this.myTransfer.getTransferOut() ? CoreTextures.ICON_BUTTON_HIGHLIGHT : CoreTextures.ICON_BUTTON, 8, 54);
            } else {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_INACTIVE, 8, 54);
            }
            this.gui.drawIcon(matrixStack, CoreTextures.ICON_INPUT, 8, 34);
            this.gui.drawIcon(matrixStack, CoreTextures.ICON_OUTPUT, 8, 54);
        }
    }

    @Override
    protected void drawBackground(PoseStack poseStack) {
        super.drawBackground(poseStack);
        if (!this.fullyOpen) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        RenderHelper.setPosTexShader();
        RenderSystem.m_157429_((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        if (this.myTransfer == null) {
            this.gui.drawTexturedModalRect(poseStack, 16, 20, 16, 20, 64, 64);
        } else {
            this.gui.drawTexturedModalRect(poseStack, 28, 20, 16, 20, 64, 64);
            this.gui.drawTexturedModalRect(poseStack, 6, 32, 16, 20, 20, 40);
        }
        RenderHelper.resetShaderColor();
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        if (!this.fullyOpen) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.configuration"));
            return;
        }
        if (this.myTransfer == null) {
            return;
        }
        int x = mouseX - this.posX();
        int y = mouseY - this.posY();
        if (8 <= x && x < 24 && 34 <= y && y < 50) {
            if (this.myTransfer.hasTransferIn()) {
                tooltipList.add((Component)(this.myTransfer.getTransferIn() ? Component.m_237115_((String)"info.cofh.transfer_in_enabled") : Component.m_237115_((String)"info.cofh.transfer_in_disabled")));
            } else {
                tooltipList.add((Component)Component.m_237115_((String)"info.cofh.transfer_in_unavailable"));
            }
        } else if (8 <= x && x < 24 && 54 <= y && y < 68) {
            if (this.myTransfer.hasTransferOut()) {
                tooltipList.add((Component)(this.myTransfer.getTransferOut() ? Component.m_237115_((String)"info.cofh.transfer_out_enabled") : Component.m_237115_((String)"info.cofh.transfer_out_disabled")));
            } else {
                tooltipList.add((Component)Component.m_237115_((String)"info.cofh.transfer_out_unavailable"));
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.fullyOpen) {
            return false;
        }
        double x = mouseX - (double)this.posX();
        double y = mouseY - (double)this.posY();
        return this.myTransfer != null ? this.clickTransfer(x, y, mouseButton) : this.clickNoTransfer(x, y, mouseButton);
    }

    protected boolean clickNoTransfer(double x, double y, int mouseButton) {
        if (x < 16.0 || x >= 80.0 || y < 20.0 || y >= 84.0) {
            return false;
        }
        Direction facing = this.myFacing.get();
        if (40.0 <= x && x < 56.0 && 24.0 <= y && y < 40.0) {
            this.handleSideChange(BlockHelper.above(facing), mouseButton);
        } else if (20.0 <= x && x < 36.0 && 44.0 <= y && y < 60.0) {
            this.handleSideChange(BlockHelper.left(facing), mouseButton);
        } else if (40.0 <= x && x < 56.0 && 44.0 <= y && y < 60.0) {
            this.handleSideChange(facing, mouseButton);
        } else if (60.0 <= x && x < 76.0 && 44.0 <= y && y < 60.0) {
            this.handleSideChange(BlockHelper.right(facing), mouseButton);
        } else if (40.0 <= x && x < 56.0 && 64.0 <= y && y < 80.0) {
            this.handleSideChange(BlockHelper.below(facing), mouseButton);
        } else if (60.0 <= x && x < 76.0 && 64.0 <= y && y < 80.0) {
            this.handleSideChange(BlockHelper.opposite(facing), mouseButton);
        }
        return true;
    }

    protected boolean clickTransfer(double x, double y, int mouseButton) {
        if (x < 4.0 || x >= 92.0 || y < 20.0 || y >= 84.0) {
            return false;
        }
        if (8.0 <= x && x < 24.0 && 34.0 <= y && y < 50.0) {
            this.handleTransferChange(true);
        } else if (8.0 <= x && x < 24.0 && 54.0 <= y && y < 68.0) {
            this.handleTransferChange(false);
        }
        Direction facing = this.myFacing.get();
        if (52.0 <= x && x < 68.0 && 24.0 <= y && y < 40.0) {
            this.handleSideChange(BlockHelper.above(facing), mouseButton);
        } else if (32.0 <= x && x < 48.0 && 44.0 <= y && y < 60.0) {
            this.handleSideChange(BlockHelper.left(facing), mouseButton);
        } else if (52.0 <= x && x < 68.0 && 44.0 <= y && y < 60.0) {
            this.handleSideChange(facing, mouseButton);
        } else if (72.0 <= x && x < 88.0 && 44.0 <= y && y < 60.0) {
            this.handleSideChange(BlockHelper.right(facing), mouseButton);
        } else if (52.0 <= x && x < 68.0 && 64.0 <= y && y < 80.0) {
            this.handleSideChange(BlockHelper.below(facing), mouseButton);
        } else if (72.0 <= x && x < 88.0 && 64.0 <= y && y < 80.0) {
            this.handleSideChange(BlockHelper.opposite(facing), mouseButton);
        }
        return true;
    }

    protected void handleTransferChange(boolean input) {
        if (this.myTransfer == null) {
            return;
        }
        if (input) {
            if (this.myTransfer.hasTransferIn()) {
                this.myTransfer.setControl(!this.myTransfer.getTransferIn(), this.myTransfer.getTransferOut());
                SoundHelper.playClickSound(this.myTransfer.getTransferIn() ? 0.6f : 0.8f);
            }
        } else if (this.myTransfer.hasTransferOut()) {
            this.myTransfer.setControl(this.myTransfer.getTransferIn(), !this.myTransfer.getTransferOut());
            SoundHelper.playClickSound(this.myTransfer.getTransferOut() ? 0.6f : 0.8f);
        }
    }

    protected void handleSideChange(Direction side, int mouseButton) {
        Direction facing = this.myFacing.get();
        if (Screen.m_96638_()) {
            if (side == facing) {
                if (this.myReconfig.clearAllSides()) {
                    SoundHelper.playClickSound(0.2f);
                }
            } else if (this.myReconfig.setSideConfig(side, IReconfigurable.SideConfig.SIDE_NONE)) {
                SoundHelper.playClickSound(0.4f);
            }
            return;
        }
        if (side == facing && !this.allowFacingConfig) {
            return;
        }
        if (mouseButton == 0) {
            if (this.myReconfig.nextSideConfig(side)) {
                SoundHelper.playClickSound(0.8f);
            }
        } else if (mouseButton == 1 && this.myReconfig.prevSideConfig(side)) {
            SoundHelper.playClickSound(0.6f);
        }
    }
}

