/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

public class ElementFluid
extends ElementBase {
    protected Supplier<FluidStack> fluidSup;

    public ElementFluid(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementFluid setFluid(Supplier<FluidStack> sup) {
        this.fluidSup = sup;
        return this;
    }

    @Override
    public void drawBackground(PoseStack matrixStack, int mouseX, int mouseY) {
        RenderHelper.drawFluid(this.guiLeft() + this.posX(), this.guiTop() + this.posY(), this.fluidSup.get(), this.width, this.height);
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        FluidStack fluid = this.fluidSup.get();
        if (!fluid.isEmpty()) {
            tooltipList.add((Component)StringHelper.getFluidName(fluid));
            if (FluidHelper.hasPotionTag(fluid)) {
                FluidHelper.addPotionTooltip(fluid, tooltipList);
            }
        }
        super.addTooltip(tooltipList, mouseX, mouseY);
    }
}

