/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.util.helpers.RenderHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.player.Player;

public interface IGuiAccess {
    public int guiTop();

    public int guiLeft();

    public Font fontRenderer();

    public Player player();

    public int blitOffset();

    default public void drawIcon(PoseStack matrixStack, TextureAtlasSprite icon, int x, int y) {
        RenderHelper.setPosTexShader();
        RenderHelper.setBlockTextureSheet();
        RenderHelper.resetShaderColor();
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)x, (int)y, (int)this.blitOffset(), (int)16, (int)16, (TextureAtlasSprite)icon);
    }

    default public void drawIcon(PoseStack matrixStack, TextureAtlasSprite icon, int color, int x, int y) {
        RenderHelper.setPosTexShader();
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setShaderColorFromInt(color);
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)x, (int)y, (int)this.blitOffset(), (int)16, (int)16, (TextureAtlasSprite)icon);
        RenderHelper.resetShaderColor();
    }

    default public void drawSizedRect(PoseStack poseStack, int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_85982_(mat, (float)x1, (float)y2, (float)this.blitOffset()).m_5752_();
        buffer.m_85982_(mat, (float)x2, (float)y2, (float)this.blitOffset()).m_5752_();
        buffer.m_85982_(mat, (float)x2, (float)y1, (float)this.blitOffset()).m_5752_();
        buffer.m_85982_(mat, (float)x1, (float)y1, (float)this.blitOffset()).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69493_();
    }

    default public void drawColoredModalRect(PoseStack poseStack, int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69405_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_);
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_85982_(mat, (float)x1, (float)y2, (float)this.blitOffset()).m_5752_();
        buffer.m_85982_(mat, (float)x2, (float)y2, (float)this.blitOffset()).m_5752_();
        buffer.m_85982_(mat, (float)x2, (float)y1, (float)this.blitOffset()).m_5752_();
        buffer.m_85982_(mat, (float)x1, (float)y1, (float)this.blitOffset()).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    default public void drawTexturedModalRect(PoseStack poseStack, int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(mat, (float)x, (float)(y + height), (float)this.blitOffset()).m_7421_((float)textureX * 0.00390625f, (float)(textureY + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_85982_(mat, (float)(x + width), (float)(y + height), (float)this.blitOffset()).m_7421_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_85982_(mat, (float)(x + width), (float)y, (float)this.blitOffset()).m_7421_((float)(textureX + width) * 0.00390625f, (float)textureY * 0.00390625f).m_5752_();
        bufferbuilder.m_85982_(mat, (float)x, (float)y, (float)this.blitOffset()).m_7421_((float)textureX * 0.00390625f, (float)textureY * 0.00390625f).m_5752_();
        tessellator.m_85914_();
    }

    default public void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(mat, (float)x, (float)(y + height), (float)this.blitOffset()).m_7421_((float)u * texU, (float)(v + height) * texV).m_5752_();
        buffer.m_85982_(mat, (float)(x + width), (float)(y + height), (float)this.blitOffset()).m_7421_((float)(u + width) * texU, (float)(v + height) * texV).m_5752_();
        buffer.m_85982_(mat, (float)(x + width), (float)y, (float)this.blitOffset()).m_7421_((float)(u + width) * texU, (float)v * texV).m_5752_();
        buffer.m_85982_(mat, (float)x, (float)y, (float)this.blitOffset()).m_7421_((float)u * texU, (float)v * texV).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

