/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.simplemagnets.ItemSpawnHandler;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class DemagnetizationCoilBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private final int minRange;
    private final int maxRange;
    private final boolean hasFilter;
    private int rangeX;
    private int rangeY;
    private int rangeZ;
    private final List<ItemStack> filter = new ArrayList<ItemStack>(9);
    private final List<ItemStack> filterView = Collections.unmodifiableList(this.filter);
    private boolean filterWhitelist;
    private boolean filterDurability = true;
    private boolean showRange;

    public DemagnetizationCoilBlockEntity(BaseBlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int minRange, int maxRange, int range, boolean hasFilter) {
        super(blockEntityType, pos, state);
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = range;
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(ItemStack.f_41583_);
        }
    }

    public void update() {
        AABB area = this.getArea();
        List affectedItems = this.f_58857_.m_142425_((EntityTypeTest)EntityType.f_20461_, area, item -> item.m_6084_() && this.shouldEffectItem(item.m_32055_()));
        affectedItems.forEach(item -> {
            item.getPersistentData().m_128379_("PreventRemoteMovement", true);
            item.getPersistentData().m_128379_("AllowMachineRemoteMovement", true);
        });
    }

    public AABB getArea() {
        return new AABB(this.f_58858_).m_82377_((double)(this.rangeX - 1), (double)(this.rangeY - 1), (double)(this.rangeZ - 1));
    }

    public boolean shouldEffectItem(ItemStack stack) {
        if (!this.hasFilter) {
            return true;
        }
        if (stack.m_41619_()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.filter.get(i);
            if (!ItemStack.m_41746_((ItemStack)filter, (ItemStack)stack) || this.filterDurability && !ItemStack.m_41658_((ItemStack)filter, (ItemStack)stack)) continue;
            return this.filterWhitelist;
        }
        return !this.filterWhitelist;
    }

    public int getRangeX() {
        return this.rangeX;
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public int getRangeY() {
        return this.rangeY;
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public int getRangeZ() {
        return this.rangeZ;
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public List<ItemStack> getFilter() {
        return this.filterView;
    }

    public void updateFilter(int index, ItemStack stack) {
        this.filter.set(index, stack);
        this.dataChanged();
    }

    public boolean getFilterWhitelist() {
        return this.filterWhitelist;
    }

    public void toggleFilterWhitelist() {
        this.filterWhitelist = !this.filterWhitelist;
        this.dataChanged();
    }

    public boolean getFilterDurability() {
        return this.filterDurability;
    }

    public void toggleFilterDurability() {
        this.filterDurability = !this.filterDurability;
        this.dataChanged();
    }

    public boolean getShowRange() {
        return this.showRange;
    }

    public void toggleShowRange() {
        this.showRange = !this.showRange;
        this.dataChanged();
    }

    protected CompoundTag writeData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("rangeX", this.rangeX);
        tag.m_128405_("rangeY", this.rangeY);
        tag.m_128405_("rangeZ", this.rangeZ);
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                if (this.filter.get(i).m_41619_()) continue;
                tag.m_128365_("filter" + i, (Tag)this.filter.get(i).m_41739_(new CompoundTag()));
            }
            tag.m_128379_("filterWhitelist", this.filterWhitelist);
            tag.m_128379_("filterDurability", this.filterDurability);
        }
        tag.m_128379_("showRange", this.showRange);
        return tag;
    }

    protected void readData(CompoundTag tag) {
        if (tag.m_128441_("rangeX")) {
            this.rangeX = tag.m_128451_("rangeX");
        }
        if (tag.m_128441_("rangeY")) {
            this.rangeY = tag.m_128451_("rangeY");
        }
        if (tag.m_128441_("rangeZ")) {
            this.rangeZ = tag.m_128451_("rangeZ");
        }
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                this.filter.set(i, tag.m_128441_("filter" + i) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("filter" + i)) : ItemStack.f_41583_);
            }
            this.filterWhitelist = tag.m_128441_("filterWhitelist") && tag.m_128471_("filterWhitelist");
            this.filterDurability = tag.m_128441_("filterDurability") && tag.m_128471_("filterDurability");
        }
        this.showRange = tag.m_128471_("showRange");
    }

    public void onLoad() {
        ItemSpawnHandler.add(this);
    }

    public static class AdvancedDemagnetizationCoilBlockEntity
    extends DemagnetizationCoilBlockEntity {
        public AdvancedDemagnetizationCoilBlockEntity(BlockPos pos, BlockState state) {
            super(SimpleMagnets.advanced_demagnetization_coil_tile, pos, state, SMConfig.advancedCoilMinRange.get(), SMConfig.advancedCoilMaxRange.get(), SMConfig.advancedCoilRange.get(), SMConfig.advancedCoilFilter.get());
        }
    }

    public static class BasicDemagnetizationCoilBlockEntity
    extends DemagnetizationCoilBlockEntity {
        public BasicDemagnetizationCoilBlockEntity(BlockPos pos, BlockState state) {
            super(SimpleMagnets.basic_demagnetization_coil_tile, pos, state, SMConfig.basicCoilMinRange.get(), SMConfig.basicCoilMaxRange.get(), SMConfig.basicCoilRange.get(), SMConfig.basicCoilFilter.get());
        }
    }
}

