/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.impl.Constants;
import net.darkhax.tipsmod.impl.client.RenderUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class TipRenderHandler {
    private static long initTime = System.currentTimeMillis();
    private static ITip tip;

    private static void setTip(ITip newTip) {
        tip = newTip;
        initTime = System.currentTimeMillis();
    }

    public static void drawTip(PoseStack pose, Screen parentScreen) {
        if (tip == null) {
            TipRenderHandler.setTip(TipsAPI.getRandomTip());
        }
        if (TipsAPI.canRenderOnScreen(parentScreen)) {
            int currentCycleTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime - initTime > (long)(currentCycleTime = tip.getCycleTime())) {
                TipRenderHandler.setTip(TipsAPI.getRandomTip());
                if (tip != null) {
                    Constants.LOG.debug("Displaying tip {} on screen {}.", (Object)tip.getId(), (Object)parentScreen.getClass().getSimpleName());
                }
            }
            if (tip != null) {
                int textWidth = Mth.m_14143_((float)((float)parentScreen.f_96543_ * 0.35f));
                int height = parentScreen.f_96544_ - 10;
                height -= RenderUtils.renderLinesReversed(pose, 10, height, (FormattedText)tip.getText(), textWidth);
                RenderUtils.renderLinesReversed(pose, 10, height -= 3, (FormattedText)tip.getTitle(), textWidth);
            }
        }
    }
}

