/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.util.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.Collection;
import net.rocketplatform.game.client.mod.util.CatalogType;
import net.rocketplatform.game.client.mod.util.gson.RuntimeTypeAdapterFactory;

public final class PolymorphicTypeReader<T> {
    private final TypeAdapterFactory factory;

    public PolymorphicTypeReader(Class<T> rootType, Class<?> catalogType) {
        this(rootType, catalogType, "type");
    }

    public PolymorphicTypeReader(Class<T> rootType, Class<?> catalogType, String typeName) {
        Collection values = CatalogType.getValues(catalogType);
        RuntimeTypeAdapterFactory typeAdapter = RuntimeTypeAdapterFactory.of(rootType, typeName);
        for (CatalogType type : values) {
            typeAdapter.registerSubtype(type.getClassType(), type.getType());
        }
        this.factory = typeAdapter;
    }

    public void applyTo(GsonBuilder builder) {
        builder.registerTypeAdapterFactory(this.factory);
    }
}

