/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.UUID;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.Vector2i;

public class PlayerFaceTemplate
extends WidgetElementTemplate {
    private static final String SIZE_KEY = "size";
    private static final int DEFAULT_SIZE = 32;
    private String uuid;

    public PlayerFaceTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public PlayerFaceTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback, String uuid, String requiredDisplayVariable) {
        super(type, id, position, callback);
        this.uuid = uuid;
        this.requiredDisplayVariable = requiredDisplayVariable;
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getSize() {
        return this.getOption(SIZE_KEY, 32);
    }

    @Override
    public Widget createElement0(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getSize(), this.getSize());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        final FaceIcon faceIcon = FaceIcon.getFace((GameProfile)new GameProfile(UUID.fromString(VariableProcessor.process(this.uuid, variableStorage)), null));
        Widget widget = new Widget(screen.getPanel()){

            public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                GuiHelper.setupDrawing();
                faceIcon.draw(graphics, x, y, this.width, this.height);
            }
        };
        widget.setPosAndSize(pos.x(), pos.y(), this.getSize(), this.getSize());
        return widget;
    }
}

