/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.type.PanelTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;

public class PanelListTemplate
extends PanelTemplate {
    @SerializedName(value="entry_loader")
    protected ListEntryLoader loader;

    public PanelListTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    @Override
    protected void addWidgets(TemplateScreen parentScreen, Panel panel, VariableStorage variableStorage, int width, int height) {
        super.addWidgets(parentScreen, panel, variableStorage, width, height);
        CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> future = this.loader.loadEntries(variableStorage);
        List<ListEntryLoader.ListEntryTemplate> templates = future.join();
        if (this.loader.isCarousel()) {
            int templateCount = templates.size();
            int paneWidth = width / templateCount;
            for (int i = 0; i < templates.size(); ++i) {
                int xOffset = i * paneWidth + paneWidth / 2 - this.loader.getWidgetWidth() / 2;
                ListEntryLoader.ListEntryTemplate template = templates.get(i);
                List<ElementTemplate<?>> elements = template.entry().elements();
                for (ElementTemplate<?> element : elements) {
                    if (!(element instanceof WidgetElementTemplate)) continue;
                    WidgetElementTemplate widgetElement = (WidgetElementTemplate)element;
                    TemplateScreen templateScreen = TemplateScreen.wrap(panel);
                    templateScreen.getStorage().inherit(variableStorage, false);
                    templateScreen.getStorage().inherit(template.storage(), true);
                    panel.add((Widget)widgetElement.createElement(templateScreen, width, height, xOffset, 0, templateScreen.getStorage()));
                }
            }
            return;
        }
        for (int i = 0; i < templates.size(); ++i) {
            int yOffset = i * this.loader.getWidgetHeight();
            ListEntryLoader.ListEntryTemplate template = templates.get(i);
            List<ElementTemplate<?>> elements = template.entry().elements();
            for (ElementTemplate<?> element : elements) {
                if (!(element instanceof WidgetElementTemplate)) continue;
                WidgetElementTemplate widgetElement = (WidgetElementTemplate)element;
                TemplateScreen templateScreen = TemplateScreen.wrap(panel);
                templateScreen.getStorage().inherit(variableStorage, false);
                templateScreen.getStorage().inherit(template.storage(), true);
                panel.add((Widget)widgetElement.createElement(templateScreen, width, height, 0, yOffset, templateScreen.getStorage()));
            }
        }
    }
}

