/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.Vector2i;

public class DividerTemplate
extends WidgetElementTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private String icon;
    @SerializedName(value="end_position")
    private ElementTemplate.Position endPosition;

    public DividerTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public Integer getWidth() {
        Number width = (Number)this.getOption(WIDTH_KEY);
        return width == null ? null : Integer.valueOf(width.intValue());
    }

    public Integer getHeight() {
        Number height = (Number)this.getOption(HEIGHT_KEY);
        return height == null ? null : Integer.valueOf(height.intValue());
    }

    public Integer getEndX() {
        if (this.endPosition == null) {
            throw new IllegalArgumentException("End position is required for DividerTemplate if width is not specified");
        }
        return this.endPosition.x();
    }

    public Integer getEndY() {
        if (this.endPosition == null) {
            throw new IllegalArgumentException("End position is required for DividerTemplate if height is not specified");
        }
        return this.endPosition.y();
    }

    @Override
    public Widget createElement0(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        final ResourceLocation icon = this.icon == null ? Screen.f_93096_ : new ResourceLocation(this.icon);
        int widgetWidth = Objects.requireNonNullElseGet(this.getWidth(), () -> screen.getWidth() - this.getEndX() - this.getPosition().x());
        int widgetHeight = Objects.requireNonNullElseGet(this.getHeight(), () -> screen.getHeight() - this.getEndY() - this.getPosition().y());
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, widgetWidth, widgetHeight);
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        Widget widget = new Widget(screen.getPanel()){

            public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                GuiHelper.setupDrawing();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f = 32.0f;
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                bufferBuilder.m_5483_(0.0, (double)this.height, 0.0).m_7421_(0.0f, (float)this.height / 32.0f + 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
                bufferBuilder.m_5483_((double)this.width, (double)this.height, 0.0).m_7421_((float)this.width / 32.0f, (float)this.height / 32.0f + 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
                bufferBuilder.m_5483_((double)this.width, 0.0, 0.0).m_7421_((float)this.width / 32.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
                bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
                tesselator.m_85914_();
            }
        };
        widget.setPosAndSize(pos.x(), pos.y(), widgetWidth, widgetHeight);
        return widget;
    }
}

