/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.GsonHelper;
import net.rocketplatform.game.client.mod.ui.repository.LayoutParser;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.ui.widget.UnrenderedWidget;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import net.rocketplatform.game.client.mod.util.Vector2i;
import net.rocketplatform.game.client.mod.util.function.IntBiConsumer;
import org.jetbrains.annotations.Nullable;

public abstract class ElementTemplate<T>
implements CallbackHolder {
    private static Map<String, List<ElementTemplate<?>>> standaloneElements;
    private String type;
    private String id;
    private Position position;
    private ElementCallback callback;
    protected Map<String, Object> options;
    @SerializedName(value="required_display_variable")
    protected String requiredDisplayVariable;

    public ElementTemplate(String type, String id, Position position, ElementCallback callback) {
        this.type = type;
        this.id = id;
        this.position = position;
        this.callback = callback;
    }

    public String getType() {
        return this.type;
    }

    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ElementCallback getCallback() {
        return this.callback;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public String getRequiredDisplayVariable() {
        return this.requiredDisplayVariable;
    }

    @Nullable
    public <V> V getOption(String key) {
        return (V)(this.options == null ? null : this.options.get(key));
    }

    public <V> V getOptionOrThrow(String key) {
        V value = this.getOption(key);
        if (value == null) {
            throw new IllegalArgumentException("Option " + key + " is required for " + this.getType() + " element");
        }
        return value;
    }

    public <V> V getOption(String key, @Nullable V defaultValue) {
        Object value = this.getOption(key);
        if (value instanceof Number) {
            Number number = (Number)value;
            if (defaultValue instanceof Number) {
                switch (defaultValue.getClass().getSimpleName()) {
                    case "Byte": {
                        value = number.byteValue();
                        break;
                    }
                    case "Short": {
                        value = number.shortValue();
                        break;
                    }
                    case "Integer": {
                        value = number.intValue();
                        break;
                    }
                    case "Long": {
                        value = number.longValue();
                        break;
                    }
                    case "Float": {
                        value = Float.valueOf(number.floatValue());
                        break;
                    }
                    case "Double": {
                        value = number.doubleValue();
                    }
                }
                return value;
            }
        }
        return value == null ? defaultValue : value;
    }

    public Pivot getPivot() {
        String pivot = this.getPosition().pivot();
        if (pivot == null) {
            pivot = "center";
        }
        return Pivot.valueOf(pivot.toUpperCase(Locale.ROOT));
    }

    public final T createElement(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        if (this.requiredDisplayVariable != null && !GuiUtils.shouldProcess(this.requiredDisplayVariable, variableStorage)) {
            return (T)((Object)new UnrenderedWidget(screen.getPanel()));
        }
        return this.createElement0(screen, elementWidth, elementHeight, offsetX, offsetY, variableStorage);
    }

    public abstract T createElement0(TemplateScreen var1, int var2, int var3, int var4, int var5, VariableStorage var6);

    @Nullable
    public static List<ElementTemplate<?>> createStandalone(String key) {
        if (standaloneElements == null) {
            return null;
        }
        return standaloneElements.get(key);
    }

    public static void loadStandalone(String json) {
        standaloneElements = (Map)GsonHelper.m_13771_((Gson)LayoutParser.getGson(), (Reader)new StringReader(json), (TypeToken)new TypeToken<Map<String, List<ElementTemplate<?>>>>(){}, (boolean)true);
    }

    public static void loadStandalone(InputStream stream) {
        standaloneElements = (Map)GsonHelper.m_13771_((Gson)LayoutParser.getGson(), (Reader)new InputStreamReader(stream), (TypeToken)new TypeToken<Map<String, List<ElementTemplate<?>>>>(){}, (boolean)true);
    }

    public static final class Position {
        private final int x;
        private final int y;
        private final String pivot;

        public Position(int x, int y, String pivot) {
            this.x = x;
            this.y = y;
            this.pivot = pivot;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public String pivot() {
            return this.pivot;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Position that = (Position)obj;
            return this.x == that.x && this.y == that.y && Objects.equals(this.pivot, that.pivot);
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.pivot);
        }

        public String toString() {
            return "Position[x=" + this.x + ", y=" + this.y + ", pivot=" + this.pivot + "]";
        }
    }

    public static enum Pivot {
        CENTER,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;


        public Vector2i apply(int elementWidth, int elementHeight, int width, int height) {
            Vector2i pos = new Vector2i();
            this.apply(pos::set, elementWidth, elementHeight, width, height);
            return pos;
        }

        public void apply(IntBiConsumer consumer, int elementWidth, int elementHeight, int width, int height) {
            switch (this) {
                case CENTER: {
                    consumer.accept(elementWidth / 2 - width / 2, elementHeight / 2 - height / 2);
                    break;
                }
                case TOP_LEFT: {
                    consumer.accept(0, 0);
                    break;
                }
                case TOP_CENTER: {
                    consumer.accept(elementWidth / 2 - width / 2, 0);
                    break;
                }
                case TOP_RIGHT: {
                    consumer.accept(elementWidth - width, 0);
                    break;
                }
                case MIDDLE_LEFT: {
                    consumer.accept(0, elementHeight / 2 - height / 2);
                    break;
                }
                case MIDDLE_RIGHT: {
                    consumer.accept(elementWidth - width, elementHeight / 2 - height / 2);
                    break;
                }
                case BOTTOM_LEFT: {
                    consumer.accept(0, elementHeight - height);
                    break;
                }
                case BOTTOM_CENTER: {
                    consumer.accept(elementWidth / 2 - width / 2, elementHeight - height);
                    break;
                }
                case BOTTOM_RIGHT: {
                    consumer.accept(elementWidth - width, elementHeight - height);
                }
            }
        }
    }
}

