/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.client.generated.CreatePlayerServerWorldResponse;
import net.rocketplatform.client.generated.CreatePlayerServerWorldResponseError;
import net.rocketplatform.client.generated.PlayerModpackServerWorld;
import net.rocketplatform.client.generated.StartWorldUploadResponse;
import net.rocketplatform.client.generated.WorldUploadProgress;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.ui.MultilineErrorScreen;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class UploadWorldCallback
extends ElementCallback {
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public UploadWorldCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        if (!variableStorage.contains("gameServerId")) {
            this.handleFailure("Unable to upload world: Could not find game server id.", null, null);
            return;
        }
        String gameServerId = (String)variableStorage.retrieve("gameServerId");
        if (!variableStorage.contains("selectedWorldPath")) {
            this.handleFailure("Unable to upload world: A world was not selected.", gameServerId, null);
            return;
        }
        String worldName = (String)variableStorage.retrieve("selectedWorldName");
        String worldPathName = (String)variableStorage.retrieve("selectedWorldPath");
        String modpackId = RocketClientMod.getInstance().getModpackId();
        String versionId = Integer.toString(RocketClientMod.getInstance().getPackMetadata().getVersion().getId());
        Path worldPath = Paths.get(worldPathName, new String[0]);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.createPlayerServerWorld(gameServerId, worldName, modpackId, versionId).thenApply(response -> Pair.of((Object)client, (Object)response)))).thenCompose(pair -> {
            RocketClientHandler client = (RocketClientHandler)pair.getKey();
            CreatePlayerServerWorldResponse response = (CreatePlayerServerWorldResponse)pair.getValue();
            if (response == null) {
                this.handleFailure("Unable to upload world: The service failed to respond.", gameServerId, null);
                return null;
            }
            if (response.getError() != null) {
                String reason = switch (response.getError()) {
                    default -> throw new IncompatibleClassChangeError();
                    case CreatePlayerServerWorldResponseError.NO_WORLD_SLOTS -> "No world slots available.";
                    case CreatePlayerServerWorldResponseError.OTHER -> "An unknown error occurred. Please report this issue!";
                };
                this.handleFailure("Unable to upload world: " + reason, gameServerId, null);
                return null;
            }
            PlayerModpackServerWorld world = response.getWorld();
            if (world == null) {
                this.handleFailure("Unable to upload world: The service failed to respond with a world.", gameServerId, null);
                return null;
            }
            return client.startWorldUpload(gameServerId, world.getWorldId()).thenApply(uploadResponse -> Triple.of((Object)client, (Object)uploadResponse, (Object)world.getWorldId()));
        })).thenComposeAsync(triple -> {
            if (triple == null || triple.getMiddle() == null) {
                this.handleFailure("Unable to upload world: The service failed to respond.", gameServerId, triple == null ? null : (Integer)triple.getRight());
                return CompletableFuture.failedFuture(new RuntimeException("No response from server."));
            }
            RocketClientHandler client = (RocketClientHandler)triple.getLeft();
            StartWorldUploadResponse response = (StartWorldUploadResponse)triple.getMiddle();
            String uploadId = response.getWorldUploadId();
            String uploadUrl = response.getUploadUrl();
            return CompletableFuture.supplyAsync(() -> {
                try {
                    URL url = URI.create(uploadUrl).toURL();
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setDoOutput(true);
                    connection.setRequestMethod("PUT");
                    connection.setRequestProperty("Content-Type", "application/tar+gzip");
                    connection.setChunkedStreamingMode(8192);
                    try (OutputStream outputStream = connection.getOutputStream();){
                        UploadWorldCallback.tarWorld(worldPath, outputStream);
                    }
                    int responseCode = connection.getResponseCode();
                    String responseMessage = connection.getResponseMessage().trim();
                    if (responseCode < 200 || responseCode >= 300) {
                        this.handleFailure("Failed to upload: HTTP " + responseCode + ". Response: " + responseMessage, gameServerId, (Integer)triple.getRight());
                        throw new IllegalStateException("Failed to upload: HTTP " + responseCode);
                    }
                    return Triple.of((Object)client, (Object)uploadId, (Object)((Integer)triple.getRight()));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to upload world: " + e.getMessage(), e);
                }
            }, Util.m_183991_());
        })).whenComplete((triple, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().info("An error occurred uploading world", e);
                this.handleFailure("Unable to upload world: " + e.getMessage(), gameServerId, null);
                return;
            }
            try {
                RocketClientHandler client = (RocketClientHandler)triple.getLeft();
                String uploadId = (String)triple.getMiddle();
                client.updateWorldUploadProgress(gameServerId, uploadId, WorldUploadProgress.UPLOAD_COMPLETED).whenComplete((response, ex) -> {
                    if (ex != null) {
                        this.handleFailure("Unable to upload world: " + ex.getMessage(), gameServerId, (Integer)triple.getRight());
                        return;
                    }
                    if (this.onComplete != null) {
                        RenderSystem.m_69879_(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
                    }
                });
            }
            catch (Throwable t) {
                RocketClientMod.getLogger().info("An error occurred completing world upload", t);
                this.handleFailure("Error occurred finalizing world upload: " + t.getMessage(), gameServerId, null);
            }
        });
    }

    private void handleFailure(String reason, String gameServerId, @Nullable Integer worldId) {
        RocketClientMod.getLogger().error(reason, new Throwable());
        if (worldId != null) {
            String modpackId = RocketClientMod.getInstance().getModpackId();
            String versionId = Integer.toString(RocketClientMod.getInstance().getPackMetadata().getVersion().getId());
            ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.deletePlayerServerWorld(gameServerId, worldId, modpackId, versionId))).whenComplete((response, e) -> {
                if (e != null) {
                    RocketClientMod.getLogger().error("Failed to delete world {}", (Object)worldId, e);
                }
            });
        }
        RenderSystem.m_69879_(() -> {
            MultilineErrorScreen errorScreen = new MultilineErrorScreen((Component)Component.m_237115_((String)"rgp_client.gui.button.ftb_worlds"), (Component)Component.m_237113_((String)reason));
            Minecraft.m_91087_().m_91152_((Screen)errorScreen);
        });
    }

    private static void tarWorld(final Path source, OutputStream outputStream) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("The file provided was not a directory!");
        }
        try (BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
             GzipCompressorOutputStream gzipStream = new GzipCompressorOutputStream((OutputStream)bufferedStream);
             final TarArchiveOutputStream tarStream = new TarArchiveOutputStream((OutputStream)gzipStream);){
            tarStream.setLongFileMode(2);
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    if (attributes.isSymbolicLink()) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetFile = source.relativize(file);
                    try {
                        TarArchiveEntry tarEntry = new TarArchiveEntry(file.toFile(), targetFile.toString());
                        tarStream.putArchiveEntry((ArchiveEntry)tarEntry);
                        Files.copy(file, (OutputStream)tarStream);
                        tarStream.closeArchiveEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to tar.gz file " + file, e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) {
                    RocketClientMod.getLogger().error("Unable to tar.gz file {}", (Object)file, (Object)e);
                    return FileVisitResult.CONTINUE;
                }
            });
            tarStream.finish();
        }
    }
}

