/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.rocketplatform.client.generated.Modpack;
import net.rocketplatform.client.generated.ModpackLoadout;
import net.rocketplatform.client.generated.ModpackLoadoutPrice;
import net.rocketplatform.client.generated.ModpackLoadoutPriceCost;
import net.rocketplatform.client.generated.ModpackRegion;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RenewServerCallback
extends ElementCallback {
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public RenewServerCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        if (!variableStorage.contains("gameServerId")) {
            RocketClientMod.getLogger().error("No game server id found in variable storage");
            return;
        }
        if (!variableStorage.contains("loadoutId")) {
            RocketClientMod.getLogger().error("No modpack id found in variable storage");
            return;
        }
        if (!variableStorage.contains("regionId")) {
            RocketClientMod.getLogger().error("No region id found in variable storage");
            return;
        }
        String gameServerId = (String)variableStorage.retrieve("gameServerId");
        String loadoutId = (String)variableStorage.retrieve("loadoutId");
        String regionId = (String)variableStorage.retrieve("regionId");
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> {
            String modpackId = RocketClientMod.getInstance().getModpackId();
            return client.getModpack(modpackId).thenCompose(pack -> client.getModpackRegions().thenApply(regions -> Pair.of((Object)pack, (Object)regions)));
        })).whenComplete((pair, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Failed to load modpack and regions", e);
                return;
            }
            Modpack modpack = (Modpack)pair.getKey();
            List regions = (List)pair.getValue();
            for (ModpackRegion region : regions) {
                if (!regionId.equals(region.getRegionId())) continue;
                variableStorage.store("selectedRegionId", region.getRegionId());
                variableStorage.store("selectedRegionName", region.getDisplayName());
                variableStorage.store("selectedLoadoutId", loadoutId);
                if (modpack != null) {
                    modpack.getLoadouts().stream().filter(ModpackLoadout::getAutoSelect).findFirst().ifPresent(loadout -> {
                        block3: {
                            variableStorage.store("selectedLoadoutName", loadout.getDisplayName());
                            variableStorage.store("selectedLoadoutDescription", loadout.getDescription());
                            variableStorage.store("selectedLoadoutNote", loadout.getNote());
                            variableStorage.store("selectedLoadoutId", loadout.getLoadoutId());
                            Iterator iterator = loadout.getPrices().iterator();
                            if (!iterator.hasNext()) break block3;
                            ModpackLoadoutPrice price = (ModpackLoadoutPrice)iterator.next();
                            variableStorage.store("selectedPriceTierName", price.getPricingTier().toString());
                            MutableComponent component = Component.m_237115_((String)("rgp_client.gui.worlds_creation.tier." + price.getPricingTier().toString().toLowerCase(Locale.ROOT)));
                            variableStorage.store("selectedPriceTierPeriod", component.getString());
                            ModpackLoadoutPriceCost priceCost = price.getPrice();
                            if (priceCost != null) {
                                variableStorage.store("selectedPriceCost", priceCost.getPrice());
                                variableStorage.store("selectedPriceCurrency", priceCost.getCurrency());
                            } else {
                                variableStorage.store("selectedPriceCost", 0);
                                variableStorage.store("selectedPriceCurrency", "usd");
                            }
                            if (this.onComplete != null) {
                                RenderSystem.m_69879_(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
                            }
                        }
                    });
                    continue;
                }
                RocketClientMod.getLogger().error("No modpack found");
            }
        });
    }
}

