/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.rocketplatform.client.generated.GameServer;
import net.rocketplatform.client.generated.GameServerState;
import net.rocketplatform.client.generated.Modpack;
import net.rocketplatform.client.generated.ModpackLoadout;
import net.rocketplatform.client.generated.OnlineGameServerInfo;
import net.rocketplatform.client.generated.OnlineGameServerStateInfo;
import net.rocketplatform.client.generated.PlayerModpackServer;
import net.rocketplatform.client.generated.PlayerModpackServerWorld;
import net.rocketplatform.client.generated.PlayerModpackServerWorldsList;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.PingUtil;
import net.rocketplatform.game.client.mod.util.ServerQuery;
import org.jetbrains.annotations.Nullable;

public class ServerEntryLoader
extends ListEntryLoader {
    public ServerEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        RocketClientMod clientMod = RocketClientMod.getInstance();
        if (clientMod.getModpackId() == null) {
            return CompletableFuture.completedFuture(List.of());
        }
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        return ((CompletableFuture)((CompletableFuture)clientMod.getClientHandler().thenCompose(RocketClientHandler::getAllPlayerServers)).thenApply(servers -> {
            clientMod.getGlobalVariables().update(servers.getClientContext());
            List<PlayerModpackServer> playerServers = this.sortServers(servers.getServers());
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            for (PlayerModpackServer server : playerServers) {
                GameProfile incompleteProfile = new GameProfile(UUID.fromString(server.getOwnerId()), null);
                incompleteProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(incompleteProfile, false);
                VariableStorage serverStorage = new VariableStorage();
                ServerEntryLoader.store(serverStorage, server, incompleteProfile.getName() == null ? "Unknown" : incompleteProfile.getName());
                List<ElementTemplate<?>> elements = ServerEntryLoader.processElements(entryTemplate, serverStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), serverStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, serverStorage));
            }
            return entries;
        })).exceptionally(e -> {
            RocketClientMod.getLogger().error("Failed to load server entries", e);
            return List.of();
        });
    }

    private List<PlayerModpackServer> sortServers(List<PlayerModpackServer> servers) {
        servers = new ArrayList<PlayerModpackServer>(servers);
        servers.sort((o1, o2) -> {
            boolean isForThisModpack2;
            boolean isOwner2;
            boolean isSuspended2;
            boolean isSuspended1 = o1.getSuspended();
            if (isSuspended1 != (isSuspended2 = o2.getSuspended().booleanValue())) {
                return isSuspended1 ? 1 : -1;
            }
            boolean isOwner1 = UUID.fromString(o1.getOwnerId()).equals(Minecraft.m_91087_().m_91094_().m_240411_());
            if (isOwner1 != (isOwner2 = UUID.fromString(o2.getOwnerId()).equals(Minecraft.m_91087_().m_91094_().m_240411_()))) {
                return isOwner1 ? -1 : 1;
            }
            boolean isForThisModpack1 = o1.getModpackId().equals(RocketClientMod.getInstance().getModpackId());
            if (isForThisModpack1 != (isForThisModpack2 = o2.getModpackId().equals(RocketClientMod.getInstance().getModpackId()))) {
                return isForThisModpack1 ? -1 : 1;
            }
            return Integer.compare(o1.getGameServerId().hashCode(), o2.getGameServerId().hashCode());
        });
        return servers;
    }

    private static void store(VariableStorage storage, PlayerModpackServer server, String ownerName) {
        boolean isOwner = UUID.fromString(server.getOwnerId()).equals(Minecraft.m_91087_().m_91094_().m_240411_());
        storage.store("gameServerInstance", server);
        storage.store("gameServerId", server.getGameServerId());
        storage.store("loadoutId", server.getLoadoutId());
        ModpackLoadout loadout = server.getLoadout();
        if (loadout != null) {
            storage.store("maxWorldSlots", loadout.getMaxWorldSlots());
        } else {
            storage.store("maxWorldSlots", 1);
        }
        String modpackForServer = server.getModpackId();
        if (modpackForServer == null || modpackForServer.equals(RocketClientMod.getInstance().getModpackId())) {
            storage.store("differentModpack", false);
        } else {
            storage.store("differentModpack", true);
        }
        storage.store("ownerId", server.getOwnerId());
        storage.store("ownerName", ownerName);
        storage.store("motd", "Dummy MOTD");
        storage.store("suspended", server.getSuspended());
        storage.store("ownerSuspended", server.getSuspended() != false && isOwner);
        storage.store("region", server.getRegionId());
        storage.store("serverName", server.getServerName() == null ? Component.m_237110_((String)"rgp_client.gui.worlds_list.server_name", (Object[])new Object[]{ownerName}).getString() : server.getServerName());
        PlayerModpackServerWorldsList worlds = server.getWorlds();
        if (worlds != null && worlds.getWorlds() != null) {
            storage.store("worldCount", worlds.getWorlds().size());
        } else {
            storage.store("worldCount", 0);
        }
        Modpack modpack = server.getModpack();
        if (modpack != null) {
            storage.store("packName", modpack.getDisplayName());
        } else {
            storage.store("packName", "");
        }
        PlayerModpackServerWorld selectedWorld = server.getSelectedWorld();
        if (selectedWorld != null) {
            if (selectedWorld.getWorldName() != null) {
                storage.store("selectedWorldName", selectedWorld.getWorldName());
            } else {
                storage.store("selectedWorldName", ownerName + "'s World");
            }
            if (selectedWorld.getWorldId() != null) {
                storage.store("selectedWorldId", selectedWorld.getWorldId());
            } else {
                storage.store("selectedWorldId", -1);
            }
        } else {
            storage.store("selectedWorldName", ownerName + "'s World");
            storage.store("selectedWorldId", -1);
        }
        storage.store("isOwner", isOwner);
        storage.store("ping", "0");
        storage.store("onlinePlayers", "");
        GameServer gameServer = server.getGameServer();
        if (gameServer == null) {
            storage.store("state", GameServerState.STOPPED);
            storage.store("joinable", false);
            storage.store("startable", true);
            storage.store("online", false);
            storage.store("serverIp", "");
            storage.store("serverPort", 0);
            storage.store("playerCount", 0);
            storage.store("maxPlayers", 0);
        } else {
            storage.store("state", gameServer.getState().toString());
            storage.store("joinable", (gameServer.getState() == GameServerState.HEALTHY || gameServer.getState() == GameServerState.STARTING || gameServer.getState() == GameServerState.STOPPED) && server.getSuspended() == false);
            storage.store("startable", gameServer.getState() == GameServerState.STOPPED);
            OnlineGameServerInfo info = gameServer.getInfo();
            if (info != null) {
                OnlineGameServerStateInfo state;
                storage.store("serverIp", info.getIp());
                storage.store("serverPort", info.getPort());
                if (gameServer.getState() == GameServerState.HEALTHY) {
                    PingUtil.pingServer(info.getIp(), info.getPort()).whenComplete((ping, e) -> {
                        if (e != null) {
                            RocketClientMod.getLogger().error("Failed to ping server", e);
                            return;
                        }
                        ServerQuery.PingResponse.Players players = ping.getPlayers();
                        if (players == null) {
                            return;
                        }
                        ArrayList<String> playerNames = new ArrayList<String>();
                        for (ServerQuery.PingResponse.Players.Player player : players.getSample()) {
                            playerNames.add(player.getName());
                        }
                        if (!playerNames.isEmpty()) {
                            storage.store("onlinePlayers", String.join((CharSequence)"\n", playerNames));
                        }
                    });
                }
                if ((state = info.getOnlineState()) != null) {
                    storage.store("playerCount", state.getPlayerCount());
                    storage.store("maxPlayers", state.getMaxPlayers());
                } else {
                    storage.store("playerCount", 0);
                    storage.store("maxPlayers", 0);
                }
            } else {
                storage.store("serverIp", "");
                storage.store("serverPort", 0);
                storage.store("playerCount", 0);
                storage.store("maxPlayers", 0);
            }
        }
    }
}

