/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.rocketplatform.client.generated.ModpackAsset;
import net.rocketplatform.client.generated.ModpackLoadout;
import net.rocketplatform.client.generated.ModpackLoadoutPrice;
import net.rocketplatform.client.generated.ModpackLoadoutPriceCost;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class ModpackLoadoutEntryLoader
extends ListEntryLoader {
    public ModpackLoadoutEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        String modpackId = RocketClientMod.getInstance().getModpackId();
        return ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getModpack(modpackId))).thenApply(modpack -> {
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            for (ModpackLoadout loadout : modpack.getLoadouts()) {
                if (!loadout.getEnabled().booleanValue()) continue;
                VariableStorage modpackStorage = new VariableStorage();
                ModpackLoadoutEntryLoader.storeLoadout(modpackStorage, loadout);
                List<ElementTemplate<?>> elements = ModpackLoadoutEntryLoader.processElements(entryTemplate, modpackStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), modpackStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, modpackStorage));
            }
            return entries;
        });
    }

    public static void storeLoadout(VariableStorage modpackStorage, ModpackLoadout loadout) {
        block2: {
            modpackStorage.store("loadoutId", loadout.getLoadoutId());
            modpackStorage.store("loadoutName", loadout.getDisplayName());
            modpackStorage.store("loadoutDescription", loadout.getDescription());
            modpackStorage.store("loadoutNote", loadout.getNote() == null ? "" : loadout.getNote());
            modpackStorage.store("loadoutTier", loadout.getTier());
            modpackStorage.store("loadoutEnabled", loadout.getEnabled());
            ModpackAsset asset = loadout.getIconAsset();
            modpackStorage.store("loadoutAssetKey", asset.getAssetKey());
            modpackStorage.store("loadoutAssetUrl", asset.getDownloadUrl());
            Iterator iterator = loadout.getPrices().iterator();
            if (!iterator.hasNext()) break block2;
            ModpackLoadoutPrice price = (ModpackLoadoutPrice)iterator.next();
            modpackStorage.store("priceTierName", price.getPricingTier().toString());
            MutableComponent component = Component.m_237115_((String)("rgp_client.gui.worlds_creation.tier." + price.getPricingTier().toString().toLowerCase(Locale.ROOT)));
            modpackStorage.store("priceTierPeriod", component.getString());
            ModpackLoadoutPriceCost priceCost = price.getPrice();
            if (priceCost != null) {
                modpackStorage.store("priceCost", priceCost.getPrice());
                modpackStorage.store("priceCurrency", priceCost.getCurrency());
            } else {
                modpackStorage.store("priceCost", 0);
                modpackStorage.store("priceCurrency", "usd");
            }
        }
    }
}

