/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.keypair;

import com.google.gson.annotations.SerializedName;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class KeyPairResponse {
    @SerializedName(value="keyPair")
    private final KeyPair keyPair;
    @SerializedName(value="publicKeySignatureV2")
    private final ByteBuffer publicKeySignature;
    @SerializedName(value="expiresAt")
    private final String expiresAt;
    @SerializedName(value="refreshedAfter")
    private final String refreshedAfter;

    public KeyPairResponse(KeyPair keyPair, ByteBuffer publicKeySignature, String expiresAt, String refreshedAfter) {
        this.keyPair = keyPair;
        this.publicKeySignature = publicKeySignature;
        this.expiresAt = expiresAt;
        this.refreshedAfter = refreshedAfter;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public ByteBuffer publicKeySignature() {
        return this.publicKeySignature;
    }

    public String expiresAt() {
        return this.expiresAt;
    }

    public String refreshedAfter() {
        return this.refreshedAfter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KeyPairResponse that = (KeyPairResponse)obj;
        return Objects.equals(this.keyPair, that.keyPair) && Objects.equals(this.publicKeySignature, that.publicKeySignature) && Objects.equals(this.expiresAt, that.expiresAt) && Objects.equals(this.refreshedAfter, that.refreshedAfter);
    }

    public int hashCode() {
        return Objects.hash(this.keyPair, this.publicKeySignature, this.expiresAt, this.refreshedAfter);
    }

    public String toString() {
        return "KeyPairResponse[keyPair=" + this.keyPair + ", publicKeySignature=" + this.publicKeySignature + ", expiresAt=" + this.expiresAt + ", refreshedAfter=" + this.refreshedAfter + "]";
    }

    public static final class KeyPair {
        @SerializedName(value="privateKey")
        private final String privateKey;
        @SerializedName(value="publicKey")
        private final String publicKey;

        public KeyPair(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public String privateKey() {
            return this.privateKey;
        }

        public String publicKey() {
            return this.publicKey;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            KeyPair that = (KeyPair)obj;
            return Objects.equals(this.privateKey, that.privateKey) && Objects.equals(this.publicKey, that.publicKey);
        }

        public int hashCode() {
            return Objects.hash(this.privateKey, this.publicKey);
        }

        public String toString() {
            return "KeyPair[privateKey=" + this.privateKey + ", publicKey=" + this.publicKey + "]";
        }
    }
}

