/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.rocketplatform.client.api.RocketClientFactory;
import net.rocketplatform.client.generated.GameServer;
import net.rocketplatform.client.generated.GameServerState;
import net.rocketplatform.client.generated.Modpack;
import net.rocketplatform.client.generated.ModpackLoadout;
import net.rocketplatform.client.generated.OnlineGameServerInfo;
import net.rocketplatform.client.generated.PlayerModpackServerWorldsList;
import net.rocketplatform.client.generated.StartAllPlayerModpackServersResponse;
import net.rocketplatform.game.client.mod.PackMetadata;
import net.rocketplatform.game.client.mod.RocketClientLogging;
import net.rocketplatform.game.client.mod.bridge.ProfileKeyPairManagerBridge;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.config.RocketClientModConfig;
import net.rocketplatform.game.client.mod.platform.ModPlatform;
import net.rocketplatform.game.client.mod.ui.MultilineToast;
import net.rocketplatform.game.client.mod.ui.PauseScreenFTBPackCompanion;
import net.rocketplatform.game.client.mod.ui.repository.LayoutLoader;
import net.rocketplatform.game.client.mod.ui.repository.LayoutParser;
import net.rocketplatform.game.client.mod.ui.repository.LayoutRepository;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.GlobalVariables;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketClientMod {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"rgp_client");
    private static final CompletableFuture<RocketClientHandler> FAILED_CLIENT_FUTURE = CompletableFuture.failedFuture(new IllegalStateException("Failed to establish connection to FTB Worlds service."));
    private static RocketClientMod instance;
    private final ModPlatform platform;
    private final LayoutRepository repository;
    private final PackMetadata packMetadata;
    private final Path configPath;
    private String modpackId;
    private CompletableFuture<RocketClientHandler> clientHandler = FAILED_CLIENT_FUTURE;
    private boolean loaded = false;
    private boolean failedVersionCheck = false;
    private boolean sessionActive = false;
    private boolean connectingToRocketServer = false;
    private boolean onRocketServer = false;
    private String rocketServerId;
    private UUID rocketServerOwner;
    private final GlobalVariables globalVariables = new GlobalVariables();

    private RocketClientMod(ModPlatform platform, Path configPath) {
        PackMetadata packMetadata;
        instance = this;
        RocketClientLogging.init();
        try {
            PauseScreenFTBPackCompanion.init();
            RocketClientMod.getLogger().info("Initialized FTB Pack Companion support.");
        }
        catch (NoClassDefFoundError e) {
            RocketClientMod.getLogger().info("Not initializing FTB Pack Companion support as it's not found.");
        }
        this.platform = platform;
        this.repository = new LayoutRepository();
        this.configPath = configPath;
        try {
            packMetadata = (PackMetadata)new Gson().fromJson(Files.readString(Paths.get("config/metadata.json", new String[0])), PackMetadata.class);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load pack metadata", (Throwable)e);
            this.packMetadata = null;
            this.clientHandler = CompletableFuture.failedFuture(new IllegalStateException("An error occurred while loading the pack metadata. Please make sure you are running a valid version of the modpack from an official source."));
            return;
        }
        this.packMetadata = packMetadata;
        this.loaded = true;
    }

    public void onInitialize(boolean initial) {
        if (initial && !this.loaded) {
            return;
        }
        if (initial) {
            LayoutParser.init();
        }
        CompletableFuture<Optional<ProfileKeyPair>> keyPairFuture = ((ProfileKeyPairManagerBridge)Minecraft.m_91087_().m_231465_()).rocket_game_mods$readKey();
        keyPairFuture.whenCompleteAsync((op, e) -> {
            if (e != null) {
                LOGGER.error("An error occurred fetching the multiplayer keypair for player. Not connecting to Rocket server services.", e);
                this.clientHandler = CompletableFuture.failedFuture(new IllegalStateException("Failed to establish connection to Mojang services. Please try again later."));
                return;
            }
            if (op.isEmpty()) {
                LOGGER.error("No keypair was present for handling authentication to Rocket keypair service. Not connecting to Rocket server services.");
                this.clientHandler = CompletableFuture.failedFuture(new IllegalStateException("Invalid authentication session. Ensure you are logged in to a valid Minecraft account, or restart your game and try again."));
                return;
            }
            LOGGER.info("Successfully fetched multiplayer keypair for player. Connecting to Rocket game services.");
            ProfileKeyPair keyPair = (ProfileKeyPair)op.get();
            CompletableFuture<RocketClientHandler> clientHandler = this.connectClient(keyPair, initial);
            if (!initial) {
                this.clientHandler.thenAccept(RocketClientHandler::disconnect);
            }
            this.clientHandler = clientHandler;
            Instant refreshTime = keyPair.f_219764_();
            long refreshDelay = refreshTime.toEpochMilli() - System.currentTimeMillis() - 30000L;
            if (refreshDelay > 0L) {
                RocketClientFactory.getScheduledThreadPool().schedule(() -> this.onInitialize(false), refreshDelay, TimeUnit.MILLISECONDS);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RocketClientHandler> connectClient(ProfileKeyPair keyPair, boolean initial) {
        try {
            CompletionStage completionStage = ((CompletableFuture)RocketClientHandler.create(Minecraft.m_91087_().m_91094_().m_240411_(), keyPair).whenComplete((handler, throwable) -> {
                if (handler != null) {
                    LOGGER.info("Created Rocket client handler successfully!");
                    this.postConnect((RocketClientHandler)handler, initial);
                }
            })).whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Failed to create Rocket client handler", throwable);
                }
            });
            return completionStage;
        }
        finally {
            LOGGER.info("Loaded Rocket Client Mod on {}", (Object)this.platform.getName());
        }
    }

    private void postConnect(RocketClientHandler handler, boolean initial) {
        if (initial) {
            String localMenusPath = System.getenv("ROCKET_CLIENT_LOCAL_MENUS");
            if (localMenusPath != null) {
                this.loadLayoutsLocally(localMenusPath);
            } else {
                this.loadLayoutsRemotely(handler);
            }
        }
        handler.listenForInviteRequests(request -> {
            String playerName;
            Boolean approved = request.getApproved();
            String sentFromPlayerId = request.getSentFromPlayerId();
            GameProfile incompleteProfile = new GameProfile(UUID.fromString(sentFromPlayerId), null);
            incompleteProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(incompleteProfile, false);
            String string = playerName = incompleteProfile.getName() == null ? "Unknown" : incompleteProfile.getName();
            if (playerName == null) {
                LOGGER.warn("Failed to get player name for {} in invite request", (Object)sentFromPlayerId);
                return;
            }
            String key = approved != false ? "rgp_client.join_request.joined" : "rgp_client.join_request.requested";
            MultilineToast inviteToast = MultilineToast.create(Minecraft.m_91087_(), (Icon)FaceIcon.getFace((GameProfile)incompleteProfile), 10000L, (Component)Component.m_237115_((String)"rgp_client.join_request.join_request"), (Component)Component.m_237110_((String)key, (Object[])new Object[]{playerName}));
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)inviteToast);
        });
        handler.listenForInviteResponses(response -> {
            String playerName;
            Boolean approved = response.getApproved();
            if (!approved.booleanValue()) {
                return;
            }
            String ownerPlayerId = response.getOwnerPlayerId();
            GameProfile incompleteProfile = new GameProfile(UUID.fromString(ownerPlayerId), null);
            incompleteProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(incompleteProfile, false);
            String string = playerName = incompleteProfile.getName() == null ? "Unknown" : incompleteProfile.getName();
            if (playerName == null) {
                LOGGER.warn("Failed to get player name for {} in invite response", (Object)ownerPlayerId);
                return;
            }
            MultilineToast inviteToast = MultilineToast.create(Minecraft.m_91087_(), (Icon)FaceIcon.getFace((GameProfile)incompleteProfile), 10000L, (Component)Component.m_237115_((String)"rgp_client.join_request.join_request"), (Component)Component.m_237110_((String)"rgp_client.join_request.accepted", (Object[])new Object[]{playerName}));
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)inviteToast);
        });
        String versionId = Integer.toString(this.packMetadata.getVersion().getId());
        this.checkVersionSupport(handler, versionId, 0);
    }

    private CompletableFuture<StartAllPlayerModpackServersResponse> checkVersionSupport(RocketClientHandler handler, String versionId, int tries) {
        CompletableFuture<Modpack> modpackIdFuture = this.fetchModpackFromForeignId(handler);
        return ((CompletableFuture)modpackIdFuture.thenCompose(modpack -> modpack == null ? CompletableFuture.completedFuture(null) : handler.startAllPlayerServers(modpack.getModpackId(), versionId).whenComplete((response, e) -> {
            this.modpackId = modpack.getModpackId();
            LOGGER.debug("Setting modpack ID to {}", (Object)this.modpackId);
            if (e != null || response == null) {
                if (e != null) {
                    LOGGER.error("Failed to start all player servers. Checking if version is supported...", e);
                } else {
                    LOGGER.error("Failed to start all player servers. Checking if version is supported...");
                }
                this.processVersionSupport(handler);
                return;
            }
            this.globalVariables.update(response.getClientContext());
            this.checkVersionSupported(handler, response.getVersionSupported());
        }))).exceptionallyCompose(e -> {
            if (tries < 10 && (e instanceof TimeoutException || e.getCause() != null && e.getCause() instanceof TimeoutException)) {
                LOGGER.info("Failed to fetch modpack id due to timeout. Retrying...");
                return this.checkVersionSupport(handler, versionId, tries + 1);
            }
            LOGGER.error("Failed to fetch modpack id", e);
            this.clientHandler.thenAccept(RocketClientHandler::disconnect);
            this.clientHandler = CompletableFuture.failedFuture(new IllegalStateException("Failed to identify the modpack that is being played. Please report this issue or try again later!"));
            return CompletableFuture.completedFuture(null);
        });
    }

    private void loadLayoutsLocally(String localMenusPath) {
        File directory = new File(localMenusPath);
        RocketClientMod.getLogger().info("Loading menus from: {}", (Object)directory.getAbsolutePath());
        this.collectJsonFiles(directory, file -> {
            if (file.getName().endsWith("standalone_elements.json")) {
                RocketClientMod.getLogger().info("Loading standalone elements from: {}", (Object)file.getAbsolutePath());
                try (FileInputStream fileInputStream = new FileInputStream((File)file);){
                    ElementTemplate.loadStandalone(fileInputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            RocketClientMod.getLogger().info("Loading menu for testing from: {}", (Object)file.getAbsolutePath());
            try (FileInputStream fileInputStream = new FileInputStream((File)file);){
                this.repository.loadLayout(fileInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void collectJsonFiles(File dir, Consumer<File> fileConsumer) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.collectJsonFiles(file, fileConsumer);
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                fileConsumer.accept(file);
            }
        }
    }

    private void loadLayoutsRemotely(RocketClientHandler handler) {
        LayoutLoader.loadLayouts(handler, 2, this.repository).whenComplete((aVoid, e) -> {
            if (e != null) {
                LOGGER.error("Failed to load menu layouts", e);
                handler.disconnect();
                this.clientHandler = CompletableFuture.failedFuture(new IllegalStateException("Failed to load menus from the FTB Worlds service. Please try again later."));
                return;
            }
        });
    }

    public CompletableFuture<Boolean> processVersionSupport(RocketClientHandler client) {
        String versionId = Integer.toString(this.packMetadata.getVersion().getId());
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        client.checkSupportedVersion(this.modpackId, versionId).whenComplete((response, e) -> {
            if (e != null) {
                client.disconnect();
                this.clientHandler = CompletableFuture.failedFuture(e);
                this.failedVersionCheck = true;
                future.completeExceptionally((Throwable)e);
                return;
            }
            this.globalVariables.update(response.getClientContext());
            this.checkVersionSupported(client, response.getVersionSupported());
            future.complete(response.getVersionSupported());
        });
        return future;
    }

    private void checkVersionSupported(RocketClientHandler client, boolean versionSupported) {
        if (versionSupported) {
            this.failedVersionCheck = false;
            return;
        }
        client.disconnect();
        this.clientHandler = CompletableFuture.failedFuture(new IllegalStateException("Version is unsupported. Please update your client."));
    }

    public void onSessionActive() {
        if (!this.loaded) {
            return;
        }
        if (this.connectingToRocketServer) {
            LOGGER.debug("Connecting to Rocket server...");
            this.connectingToRocketServer = false;
            this.onRocketServer = true;
        }
        if (this.onRocketServer) {
            UUID serverOwner = this.getRocketServerOwner();
            if (serverOwner != null && serverOwner.equals(Minecraft.m_91087_().m_91094_().m_240411_())) {
                try {
                    PauseScreenFTBPackCompanion.getInstance().show();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            PauseScreenFTBPackCompanion.getInstance().hide();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.sessionActive = true;
        this.clientHandler.thenAccept(client -> {
            try {
                client.pause();
            }
            catch (Throwable e) {
                RocketClientMod.getLogger().error("An error occurred pausing client.", e);
            }
        });
        RocketClientMod.getLogger().info("Disconnected Rocket client as session is active.");
    }

    public void onSessionInactive() {
        if (!this.loaded) {
            return;
        }
        if (!this.sessionActive) {
            return;
        }
        this.sessionActive = false;
        this.clientHandler.thenAccept(client -> {
            try {
                RocketClientMod.getLogger().info("Reconnected Rocket client as session has become inactive.");
                client.unpause();
            }
            catch (Throwable e) {
                RocketClientMod.getLogger().error("An error occurred unpausing client.", e);
            }
        });
    }

    public static RocketClientMod load(ModPlatform platform, Path configPath) {
        if (instance != null) {
            throw new IllegalStateException("Cannot redefine singleton RocketClientMod");
        }
        return new RocketClientMod(platform, configPath);
    }

    public ModPlatform getPlatform() {
        return this.platform;
    }

    public LayoutRepository getLayoutRepository() {
        return this.repository;
    }

    public String getModpackId() {
        if (this.modpackId == null) {
            ((CompletableFuture)this.clientHandler.thenCompose(this::fetchModpackFromForeignId)).whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    RocketClientMod.getLogger().error("An error occurred getting mod pack foreign id.", throwable);
                }
            });
        }
        return this.modpackId;
    }

    public PackMetadata getPackMetadata() {
        return this.packMetadata;
    }

    public CompletableFuture<RocketClientHandler> getClientHandler() {
        return this.clientHandler;
    }

    public boolean isSessionActive() {
        return this.sessionActive;
    }

    public boolean isConnectingToRocketServer() {
        return this.connectingToRocketServer;
    }

    public void setConnectingToRocketServer(boolean connectingToRocketServer) {
        this.connectingToRocketServer = connectingToRocketServer;
    }

    public boolean isOnRocketServer() {
        return this.onRocketServer;
    }

    public void setOnRocketServer(boolean onRocketServer) {
        this.onRocketServer = onRocketServer;
    }

    public String getRocketServerId() {
        return this.rocketServerId;
    }

    public void setRocketServerId(String rocketServerId) {
        this.rocketServerId = rocketServerId;
    }

    public UUID getRocketServerOwner() {
        return this.rocketServerOwner;
    }

    public void setRocketServerOwner(UUID rocketServerOwner) {
        this.rocketServerOwner = rocketServerOwner;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void openConfigurationScreen() {
        LayoutTemplate template = RocketClientMod.getInstance().getLayoutRepository().getLayout((String)RocketClientModConfig.CONFIG.configScreenLayout.get());
        if (template == null) {
            throw new IllegalStateException("Cannot find layout with id " + (String)RocketClientModConfig.CONFIG.configScreenLayout.get());
        }
        ((CompletableFuture)this.clientHandler.thenCompose(client -> client.getPlayerServerInfo(this.rocketServerId))).whenComplete((server, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Failed to fetch server info", e);
                return;
            }
            try {
                GameServer gameServer = server.getGameServer();
                if (gameServer == null) {
                    RocketClientMod.getLogger().error("Failed to fetch server info");
                    return;
                }
                OnlineGameServerInfo info = gameServer.getInfo();
                VariableStorage storage = new VariableStorage();
                storage.store("selectedServer", server);
                storage.store("gameServerId", this.rocketServerId);
                if (info != null) {
                    storage.store("serverIp", info.getIp());
                    storage.store("serverPort", info.getPort());
                    storage.store("joinable", (gameServer.getState() == GameServerState.HEALTHY || gameServer.getState() == GameServerState.STARTING || gameServer.getState() == GameServerState.STOPPED) && server.getSuspended() == false);
                    storage.store("playerCount", info.getOnlineState().getPlayerCount());
                } else {
                    storage.store("serverIp", "");
                    storage.store("serverPort", "");
                    storage.store("joinable", false);
                }
                ModpackLoadout loadout = server.getLoadout();
                if (loadout != null) {
                    storage.store("maxWorldSlots", loadout.getMaxWorldSlots());
                } else {
                    storage.store("maxWorldSlots", 1);
                }
                PlayerModpackServerWorldsList worlds = server.getWorlds();
                if (worlds != null && worlds.getWorlds() != null) {
                    storage.store("worldCount", worlds.getWorlds().size());
                } else {
                    storage.store("worldCount", 0);
                }
                storage.store("state", gameServer.getState());
                boolean isOwner = UUID.fromString(server.getOwnerId()).equals(Minecraft.m_91087_().m_91094_().m_240411_());
                GameProfile incompleteProfile = new GameProfile(UUID.fromString(server.getOwnerId()), null);
                incompleteProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(incompleteProfile, false);
                String ownerName = incompleteProfile.getName() == null ? "Unknown" : incompleteProfile.getName();
                storage.store("isOwner", isOwner);
                storage.store("serverName", server.getServerName() == null ? Component.m_237110_((String)"rgp_client.gui.worlds_list.server_name", (Object[])new Object[]{ownerName}).getString() : server.getServerName());
                storage.store("parentScreen", "pause");
                RenderSystem.m_69879_(() -> Minecraft.m_91087_().m_91152_(template.createScreen(storage)));
            }
            catch (Throwable t) {
                LOGGER.error("An error occurred when opening the server configuration screen.", t);
            }
        });
    }

    public boolean hasFailedVersionCheck() {
        return this.failedVersionCheck;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private CompletableFuture<Modpack> fetchModpackFromForeignId(RocketClientHandler handler) {
        return handler.getModpackFromForeignId(Integer.toString(this.packMetadata.getId()));
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static RocketClientMod getInstance() {
        if (instance == null) {
            throw new IllegalStateException("RocketClientMod has not been loaded");
        }
        return instance;
    }
}

