/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.nebs;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.infernalstudios.nebs.NekosEnchantedBooks;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "nebs", existingFileHelper);
    }

    public ModelFile generateModel(String name) {
        ResourceLocation location = this.modLoc("items/" + name);
        if (!this.existingFileHelper.exists(location, PackType.CLIENT_RESOURCES, ".png", "textures")) {
            NekosEnchantedBooks.LOGGER.debug(name + " book texture not found, defaulting...");
            location = this.mcLoc("item/enchanted_book");
        }
        return ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", location);
    }

    protected void registerModels() {
        if (NekosEnchantedBooks.enchantmentMap == null) {
            InputStreamReader input = new InputStreamReader(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("assets/nebs/models/properties.json")), StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<String, Float>>(){}.getType();
            NekosEnchantedBooks.enchantmentMap = (Map)new Gson().fromJson((Reader)new BufferedReader(input), type);
        }
        ItemModelBuilder enchanted_book = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("minecraft:item/enchanted_book")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.mcLoc("item/enchanted_book"));
        for (Map.Entry<String, Float> entry : NekosEnchantedBooks.enchantmentMap.entrySet()) {
            ModelFile file = this.generateModel(entry.getKey().split("\\.")[2]);
            enchanted_book.override().predicate(this.modLoc("enchant"), entry.getValue().floatValue()).model(file).end();
        }
    }
}

