/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.fakeplayer;

import com.mojang.authlib.GameProfile;
import de.srendi.advancedperipherals.common.util.Pair;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class APFakePlayer
extends FakePlayer {
    public static final GameProfile PROFILE = new GameProfile(UUID.fromString("6e483f02-30db-4454-b612-3a167614b276"), "[advancedperipherals]");
    private static final Predicate<Entity> collidablePredicate = EntitySelector.f_20408_;
    private final WeakReference<Entity> owner;
    private BlockPos digPosition;
    private Block digBlock;
    private float currentDamage = 0.0f;

    public APFakePlayer(ServerLevel world, Entity owner, GameProfile profile) {
        super(world, profile != null && profile.isComplete() ? profile : PROFILE);
        if (owner != null) {
            this.m_6593_(owner.m_7755_());
            this.owner = new WeakReference<Entity>(owner);
        } else {
            this.owner = null;
        }
    }

    public void m_36246_(@NotNull Stat<?> stat) {
        ServerPlayer player;
        MinecraftServer server = this.f_19853_.m_7654_();
        if (server != null && this.m_36316_() != PROFILE && (player = server.m_6846_().m_11259_(this.m_20148_())) != null) {
            player.m_36246_(stat);
        }
    }

    public boolean m_6779_(@NotNull LivingEntity livingEntity) {
        return true;
    }

    public void m_7739_(@NotNull SignBlockEntity sign) {
    }

    public boolean m_20067_() {
        return true;
    }

    public void m_5496_(@NotNull SoundEvent soundIn, float volume, float pitch) {
    }

    private void setState(Block block, BlockPos pos) {
        if (this.digPosition != null) {
            this.f_8941_.m_214168_(this.digPosition, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.EAST, 320, 1);
        }
        this.digPosition = pos;
        this.digBlock = block;
        this.currentDamage = 0.0f;
    }

    public float m_20236_(@NotNull Pose pose) {
        return 0.0f;
    }

    public static <T> Function<APFakePlayer, T> wrapActionWithRot(float yaw, float pitch, Function<APFakePlayer, T> action) {
        return player -> player.doActionWithRot(yaw, pitch, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doActionWithRot(float yaw, float pitch, Function<APFakePlayer, T> action) {
        float oldRot = this.m_146908_();
        this.m_19915_(oldRot + yaw, pitch);
        try {
            T t = action.apply(this);
            return t;
        }
        finally {
            this.m_19915_(oldRot, 0.0f);
        }
    }

    public static <T> Function<APFakePlayer, T> wrapActionWithShiftKey(boolean shift, Function<APFakePlayer, T> action) {
        return player -> player.doActionWithShiftKey(shift, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doActionWithShiftKey(boolean shift, Function<APFakePlayer, T> action) {
        boolean old = this.m_6144_();
        this.m_20260_(shift);
        try {
            T t = action.apply(this);
            return t;
        }
        finally {
            this.m_20260_(old);
        }
    }

    @Deprecated(forRemoval=true)
    public Pair<Boolean, String> digBlock(Direction direction) {
        return this.doActionWithRot(direction.m_122435_() - this.m_146908_(), direction == Direction.DOWN ? 90.0f : (direction == Direction.UP ? -90.0f : 0.0f), APFakePlayer::digBlock);
    }

    public Pair<Boolean, String> digBlock() {
        ServerLevel world = this.m_9236_();
        HitResult hit = this.findHit(true, false);
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return Pair.of(false, "Nothing to break");
        }
        BlockPos pos = new BlockPos(hit.m_82450_());
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        ItemStack tool = this.m_150109_().m_36056_();
        if (tool.m_41619_()) {
            return Pair.of(false, "Cannot dig without tool");
        }
        if (block != this.digBlock || !pos.equals((Object)this.digPosition)) {
            this.setState(block, pos);
        }
        Vec3 look = this.m_20154_();
        Direction direction = Direction.m_122366_((double)look.f_82479_, (double)look.f_82480_, (double)look.f_82481_).m_122424_();
        if (world.m_46859_(pos) || state.m_60767_().m_76332_()) {
            return Pair.of(false, "Nothing to dig here");
        }
        if (block == Blocks.f_50752_ || state.m_60800_((BlockGetter)world, pos) <= -1.0f) {
            return Pair.of(false, "Unbreakable block detected");
        }
        if (!tool.m_41735_(state)) {
            return Pair.of(false, "Tool cannot mine this block");
        }
        ServerPlayerGameMode manager = this.f_8941_;
        float breakSpeed = 0.5f * tool.m_41691_(state) / state.m_60800_((BlockGetter)this.f_19853_, pos) - 0.1f;
        for (int i = 0; i < 10; ++i) {
            this.currentDamage += breakSpeed;
            world.m_6801_(this.m_19879_(), pos, i);
            if (!(this.currentDamage > 9.0f)) continue;
            world.m_5594_(null, pos, state.m_60827_().m_56778_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
            manager.m_214168_(pos, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, direction, 320, 1);
            manager.m_9280_(pos);
            world.m_6801_(this.m_19879_(), pos, -1);
            this.setState(null, null);
            break;
        }
        return Pair.of(true, "block");
    }

    public InteractionResult useOnBlock() {
        return this.use(true, false);
    }

    public InteractionResult useOnEntity() {
        return this.use(false, true);
    }

    public InteractionResult useOnFilteredEntity(Predicate<Entity> filter) {
        return this.use(false, true, filter);
    }

    public InteractionResult useOnSpecificEntity(@NotNull Entity entity, HitResult result) {
        InteractionResult simpleInteraction = this.m_36157_(entity, InteractionHand.MAIN_HAND);
        if (simpleInteraction == InteractionResult.SUCCESS) {
            return simpleInteraction;
        }
        if (ForgeHooks.onInteractEntityAt((Player)this, (Entity)entity, (Vec3)result.m_82450_(), (InteractionHand)InteractionHand.MAIN_HAND) != null) {
            return InteractionResult.FAIL;
        }
        return entity.m_7111_((Player)this, result.m_82450_(), InteractionHand.MAIN_HAND);
    }

    public InteractionResult use(boolean skipEntity, boolean skipBlock) {
        return this.use(skipEntity, skipBlock, null);
    }

    public InteractionResult use(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        HitResult hit = this.findHit(skipEntity, skipBlock, entityFilter);
        if (hit instanceof BlockHitResult) {
            BlockItem blockItem;
            Block block;
            boolean usedOnBlock;
            BlockHitResult blockHit = (BlockHitResult)hit;
            ItemStack stack = this.m_21205_();
            BlockPos pos = blockHit.m_82425_();
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)this, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)blockHit);
            if (event.isCanceled()) {
                return event.getCancellationResult();
            }
            boolean usedItem = event.getUseItem() != Event.Result.DENY;
            boolean bl = usedOnBlock = event.getUseBlock() != Event.Result.DENY;
            if (usedItem) {
                InteractionResult useType;
                InteractionResult result = stack.onItemUseFirst(new UseOnContext(this.f_19853_, (Player)this, InteractionHand.MAIN_HAND, stack, blockHit));
                if (result != InteractionResult.PASS) {
                    return result;
                }
                boolean bypass = this.m_21205_().doesSneakBypassUse((LevelReader)this.f_19853_, pos, (Player)this);
                if ((this.m_6144_() || bypass || usedOnBlock) && (useType = this.f_8941_.m_7179_((ServerPlayer)this, this.f_19853_, stack, InteractionHand.MAIN_HAND, blockHit)).m_19077_()) {
                    return useType;
                }
            }
            if (!stack.m_41619_() && this.m_36335_().m_41519_(stack.m_41720_())) {
                return InteractionResult.PASS;
            }
            Item bypass = stack.m_41720_();
            if (bypass instanceof BlockItem && ((block = (blockItem = (BlockItem)bypass).m_40614_()) instanceof CommandBlock || block instanceof StructureBlock)) {
                return InteractionResult.FAIL;
            }
            if (!usedItem && !usedOnBlock) {
                return InteractionResult.PASS;
            }
            ItemStack copyBeforeUse = stack.m_41777_();
            InteractionResult result = stack.m_41661_(new UseOnContext(this.f_19853_, (Player)this, InteractionHand.MAIN_HAND, stack, blockHit));
            if (stack.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)this, (ItemStack)copyBeforeUse, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            return result;
        }
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            return this.useOnSpecificEntity(entityHit.m_82443_(), (HitResult)entityHit);
        }
        return InteractionResult.FAIL;
    }

    public HitResult findHit(boolean skipEntity, boolean skipBlock) {
        return this.findHit(skipEntity, skipBlock, null);
    }

    @NotNull
    public HitResult findHit(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        AttributeInstance reachAttribute = this.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttribute == null) {
            throw new IllegalArgumentException("How did this happened?");
        }
        double range = reachAttribute.m_22135_();
        Vec3 origin = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 look = this.m_20154_();
        Vec3 target = new Vec3(origin.f_82479_ + look.f_82479_ * range, origin.f_82480_ + look.f_82480_ * range, origin.f_82481_ + look.f_82481_ * range);
        ClipContext traceContext = new ClipContext(origin, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this);
        Vec3 directionVec = traceContext.m_45702_().m_82546_(traceContext.m_45693_());
        Direction traceDirection = Direction.m_122366_((double)directionVec.f_82479_, (double)directionVec.f_82480_, (double)directionVec.f_82481_);
        Object blockHit = skipBlock ? BlockHitResult.m_82426_((Vec3)traceContext.m_45693_(), (Direction)traceDirection, (BlockPos)new BlockPos(traceContext.m_45693_())) : (HitResult)BlockGetter.m_151361_((Vec3)traceContext.m_45702_(), (Vec3)traceContext.m_45693_(), (Object)traceContext, (rayTraceContext, blockPos) -> {
            if (this.f_19853_.m_46859_(blockPos) || blockPos.equals((Object)this.m_20183_())) {
                return null;
            }
            return new BlockHitResult(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), traceDirection, blockPos, false);
        }, rayTraceContext -> BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)traceDirection, (BlockPos)new BlockPos(rayTraceContext.m_45693_())));
        if (skipEntity) {
            return blockHit;
        }
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82363_(look.f_82479_ * range, look.f_82480_ * range, look.f_82481_ * range).m_82400_(1.0), collidablePredicate);
        LivingEntity closestEntity = null;
        Vec3 closestVec = null;
        double closestDistance = blockHit.m_6662_() == HitResult.Type.MISS ? range * range : this.m_20238_(blockHit.m_82450_());
        for (Entity entityHit : entities) {
            Vec3 clipVec;
            if (!(entityHit instanceof LivingEntity)) continue;
            LivingEntity entity = (LivingEntity)entityHit;
            if (entityFilter != null && !entityFilter.test((Entity)entity) || entity.m_20159_()) continue;
            AABB box = entity.m_20191_();
            if (box.m_82390_(origin)) {
                clipVec = origin;
            } else {
                clipVec = box.m_82371_(origin, target).orElse(null);
                if (clipVec == null) continue;
            }
            double distance = origin.m_82557_(clipVec);
            if (distance <= 1.0E-6) {
                distance = 0.0;
            }
            if (distance > closestDistance || distance == closestDistance && closestEntity != null && closestEntity.m_20191_().m_82309_() >= box.m_82309_()) continue;
            closestEntity = entity;
            closestVec = clipVec;
            closestDistance = distance;
        }
        if (closestEntity != null) {
            return new EntityHitResult(closestEntity, closestVec);
        }
        return blockHit;
    }
}

