/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.FuelAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomataWarpingPlugin
extends AutomataCorePlugin {
    private static final String POINT_DATA_MARK = "warp_points";
    private static final String WORLD_DATA_MARK = "warp_world";

    public AutomataWarpingPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.WARP};
    }

    @NotNull
    protected Pair<MethodResult, CompoundTag> getPointData() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        CompoundTag settings = owner.getDataStorage();
        if (!settings.m_128441_(WORLD_DATA_MARK)) {
            settings.m_128359_(WORLD_DATA_MARK, owner.getLevel().m_46472_().m_135782_().toString());
        } else {
            String worldName = settings.m_128461_(WORLD_DATA_MARK);
            if (!owner.getLevel().m_46472_().m_135782_().toString().equals(worldName)) {
                return Pair.onlyLeft(MethodResult.of((Object[])new Object[]{null, "Incorrect world for this upgrade"}));
            }
        }
        if (!settings.m_128441_(POINT_DATA_MARK)) {
            settings.m_128365_(POINT_DATA_MARK, (Tag)new CompoundTag());
        }
        return Pair.onlyRight(settings.m_128469_(POINT_DATA_MARK));
    }

    private int getWarpCost(SingleOperationContext context) {
        FuelAbility<?> fuelAbility = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getAbility(PeripheralOwnerAbility.FUEL);
        Objects.requireNonNull(fuelAbility);
        return SingleOperation.WARP.getCost(context) * fuelAbility.getFuelConsumptionMultiply();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult savePoint(String name) {
        this.automataCore.addRotationCycle();
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        if (data.m_128431_().size() >= (Integer)APConfig.METAPHYSICS_CONFIG.endAutomataCoreWarpPointLimit.get()) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot add new point, limit reached"});
        }
        data.m_128365_(name, (Tag)NBTUtil.toNBT(((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getPos()));
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult deletePoint(String name) {
        this.automataCore.addRotationCycle();
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        if (!data.m_128441_(name)) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot find point to delete"});
        }
        data.m_128473_(name);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult points() {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        return MethodResult.of((Object)data.m_128431_());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult warpToPoint(String name) throws LuaException {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        Level level = owner.getLevel();
        CompoundTag data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.m_128469_(name));
        return this.automataCore.withOperation(SingleOperation.WARP, this.automataCore.toDistance(newPosition), context -> {
            boolean result = owner.move(level, newPosition);
            if (!result) {
                return MethodResult.of((Object[])new Object[]{null, "Cannot teleport to location"});
            }
            return MethodResult.of((Object)true);
        }, context -> {
            if (!owner.isMovementPossible(level, newPosition)) {
                return MethodResult.of((Object[])new Object[]{null, "Move forbidden"});
            }
            return null;
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult estimateWarpCost(String name) {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.m_128469_(name));
        return MethodResult.of((Object)this.getWarpCost(this.automataCore.toDistance(newPosition)));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult distanceToPoint(String name) {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.m_128469_(name));
        return MethodResult.of((Object)newPosition.m_123333_((Vec3i)((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getPos()));
    }
}

