/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class EnvironmentDetectorPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "environmentDetector";
    private static final List<Function<IPeripheralOwner, IPeripheralPlugin>> PERIPHERAL_PLUGINS = new LinkedList<Function<IPeripheralOwner, IPeripheralPlugin>>();

    protected EnvironmentDetectorPeripheral(IPeripheralOwner owner) {
        super(PERIPHERAL_TYPE, owner);
        owner.attachOperation(SphereOperation.SCAN_ENTITIES);
        for (Function<IPeripheralOwner, IPeripheralPlugin> plugin : PERIPHERAL_PLUGINS) {
            this.addPlugin(plugin.apply(owner));
        }
    }

    public EnvironmentDetectorPeripheral(PeripheralBlockEntity<?> tileEntity) {
        this(new BlockEntityPeripheralOwner(tileEntity).attachFuel());
    }

    public EnvironmentDetectorPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side).attachFuel(1));
    }

    public EnvironmentDetectorPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    private static int estimateCost(int radius) {
        if (radius <= SphereOperation.SCAN_ENTITIES.getMaxFreeRadius()) {
            return 0;
        }
        if (radius > SphereOperation.SCAN_ENTITIES.getMaxCostRadius()) {
            return -1;
        }
        return SphereOperation.SCAN_ENTITIES.getCost(SphereOperationContext.of(radius));
    }

    public static void addIntegrationPlugin(Function<IPeripheralOwner, IPeripheralPlugin> plugin) {
        PERIPHERAL_PLUGINS.add(plugin);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableEnergyDetector.get();
    }

    @LuaFunction(mainThread=true)
    public final String getBiome() {
        Optional biome = this.getLevel().m_204166_(this.getPos()).m_203543_();
        return biome.map(biomeResourceKey -> biomeResourceKey.m_135782_().toString()).orElse("unknown");
    }

    @LuaFunction(mainThread=true)
    public final int getSkyLightLevel() {
        return this.getLevel().m_45517_(LightLayer.SKY, this.getPos().m_7918_(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getBlockLightLevel() {
        return this.getLevel().m_45517_(LightLayer.BLOCK, this.getPos().m_7918_(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getDayLightLevel() {
        Level level = this.getLevel();
        int i = level.m_45517_(LightLayer.SKY, this.getPos().m_7918_(0, 1, 0)) - level.m_7445_();
        float f = level.m_46490_(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * Mth.m_14089_((float)f));
        }
        i = Mth.m_14045_((int)i, (int)0, (int)15);
        return i;
    }

    @LuaFunction(mainThread=true)
    public final long getTime() {
        return this.getLevel().m_46468_();
    }

    @LuaFunction(mainThread=true)
    public final boolean isSlimeChunk() {
        ChunkPos chunkPos = new ChunkPos(this.getPos());
        return WorldgenRandom.m_224681_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)((WorldGenLevel)this.getLevel()).m_7328_(), (long)987234911L).m_188503_(10) == 0;
    }

    @LuaFunction(mainThread=true)
    public final String getDimension() {
        return this.getLevel().m_46472_().m_135782_().toString();
    }

    @LuaFunction(mainThread=true)
    public final boolean isDimension(String dimension) {
        return this.getLevel().m_46472_().m_135782_().toString().equals(dimension);
    }

    @LuaFunction(mainThread=true)
    public final Set<String> listDimensions() {
        HashSet<String> dimensions = new HashSet<String>();
        ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(serverWorld -> dimensions.add(serverWorld.m_46472_().m_135782_().m_135815_()));
        return dimensions;
    }

    @LuaFunction(mainThread=true)
    public final int getMoonId() {
        return this.getCurrentMoonPhase().keySet().toArray(new Integer[0])[0];
    }

    @LuaFunction(mainThread=true)
    public final boolean isMoon(int phase) {
        return this.getCurrentMoonPhase().containsKey(phase);
    }

    @LuaFunction(mainThread=true)
    public final String getMoonName() {
        String[] name = this.getCurrentMoonPhase().values().toArray(new String[0]);
        return name[0];
    }

    private Map<Integer, String> getCurrentMoonPhase() {
        HashMap<Integer, String> moon = new HashMap<Integer, String>();
        if (this.getLevel().m_46472_() == Level.f_46428_) {
            switch (this.getLevel().m_46941_()) {
                case 0: {
                    moon.put(0, "Full moon");
                    break;
                }
                case 1: {
                    moon.put(1, "Waning gibbous");
                    break;
                }
                case 2: {
                    moon.put(2, "Third quarter");
                    break;
                }
                case 3: {
                    moon.put(3, "Wanning crescent");
                    break;
                }
                case 4: {
                    moon.put(4, "New moon");
                    break;
                }
                case 5: {
                    moon.put(5, "Waxing crescent");
                    break;
                }
                case 6: {
                    moon.put(6, "First quarter");
                    break;
                }
                case 7: {
                    moon.put(7, "Waxing gibbous");
                    break;
                }
                default: {
                    moon.put(0, "What is a moon");
                    break;
                }
            }
        } else {
            moon.put(0, "Moon.exe not found...");
        }
        return moon;
    }

    @LuaFunction(mainThread=true)
    public final boolean isRaining() {
        return this.getLevel().m_46722_(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isThunder() {
        return this.getLevel().m_46661_(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSunny() {
        return this.getLevel().m_46661_(0.0f) < 1.0f && this.getLevel().m_46722_(0.0f) < 1.0f;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scanEntities(@NotNull IComputerAccess access, @NotNull IArguments arguments) throws LuaException {
        int radius = arguments.getInt(0);
        return this.withOperation(SphereOperation.SCAN_ENTITIES, new SphereOperationContext(radius), context -> {
            if (radius > SphereOperation.SCAN_ENTITIES.getMaxCostRadius()) {
                return MethodResult.of((Object[])new Object[]{null, "Radius exceeds max value"});
            }
            return null;
        }, context -> {
            BlockPos pos = this.owner.getPos();
            AABB box = new AABB(pos);
            ArrayList entities = new ArrayList();
            this.getLevel().m_6249_((Entity)null, box.m_82400_((double)radius), LivingEntity.class::isInstance).forEach(entity -> entities.add(LuaConverter.completeEntityWithPositionToLua(entity, ItemStack.f_41583_, pos)));
            return MethodResult.of(entities);
        }, null);
    }

    @LuaFunction
    public final MethodResult scanCost(int radius) {
        int estimatedCost = EnvironmentDetectorPeripheral.estimateCost(radius);
        if (estimatedCost < 0) {
            return MethodResult.of((Object[])new Object[]{null, "Radius exceeds max value"});
        }
        return MethodResult.of((Object)estimatedCost);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult canSleepHere() {
        return MethodResult.of((Object)(!this.getLevel().m_46461_() ? 1 : 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult canSleepPlayer(String playername) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(playername);
        if (player == null) {
            return MethodResult.of((Object[])new Object[]{false, "player_not_online"});
        }
        if (!player.f_19853_.m_6042_().f_63862_()) {
            return MethodResult.of((Object[])new Object[]{false, "not_allowed_in_dimension"});
        }
        SleepingTimeCheckEvent evt = new SleepingTimeCheckEvent((Player)player, Optional.empty());
        MinecraftForge.EVENT_BUS.post((Event)evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            return MethodResult.of((Object)(!player.f_19853_.m_46461_() ? 1 : 0));
        }
        return MethodResult.of((Object)(canContinueSleep == Event.Result.ALLOW ? 1 : 0));
    }
}

