/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.items;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAItem
extends Item
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;
    protected final IItemFormSettings settings;
    protected IntSupplier maxStackSize;
    protected BooleanSupplier hasEffect;
    protected Supplier<Rarity> rarity;
    protected IntSupplier burnTime;

    public JAOPCAItem(IForm form, IMaterial material, IItemFormSettings settings) {
        super(new Item.Properties().m_41491_(ItemFormType.getCreativeTab()));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.maxStackSize = MemoizingSuppliers.of(settings.getMaxStackSizeFunction(), () -> material);
        this.hasEffect = MemoizingSuppliers.of(settings.getHasEffectFunction(), () -> material);
        this.rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), () -> material);
        this.burnTime = MemoizingSuppliers.of(settings.getBurnTimeFunction(), () -> material);
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.maxStackSize.getAsInt();
    }

    public boolean m_5812_(ItemStack stack) {
        return this.hasEffect.getAsBoolean() || super.m_5812_(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.rarity.get();
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return this.burnTime.getAsInt();
    }

    public Component m_7626_(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.form.getName(), this.material, this.m_5671_(stack));
    }
}

