/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagManager;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.ClassUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import thelm.jaopca.api.data.IDataModule;
import thelm.jaopca.api.data.JAOPCADataModule;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.resources.InMemoryResourcePack;
import thelm.jaopca.utils.MiscHelper;

public class DataInjector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type JAOPCA_DATA_MODULE = Type.getType(JAOPCADataModule.class);
    private static final Map<Class<?>, Consumer<Object>> RELOAD_INJECTORS = new HashMap();
    private static final LoadingCache<ResourceKey<? extends Registry<?>>, ListMultimap<ResourceLocation, ResourceLocation>> TAGS_INJECT = CacheBuilder.newBuilder().build(CacheLoader.from(() -> MultimapBuilder.treeKeys().arrayListValues().build()));
    private static final TreeMap<ResourceLocation, IRecipeSerializer> RECIPES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<LootTable>> LOOT_TABLES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<Advancement.Builder>> ADVANCEMENTS_INJECT = new TreeMap();
    private static final Gson GSON = Deserializers.m_78800_().create();

    public static void init() {
        RELOAD_INJECTORS.put(RecipeManager.class, DataInjector::injectRecipes);
    }

    public static boolean registerReloadInjector(Class<?> clazz, Consumer<Object> injector) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(injector);
        return RELOAD_INJECTORS.putIfAbsent(clazz, injector) == null;
    }

    public static boolean registerTag(ResourceKey<? extends Registry<?>> registry, ResourceLocation tagLocation, ResourceLocation objLocation) {
        Objects.requireNonNull(registry);
        Objects.requireNonNull(tagLocation);
        Objects.requireNonNull(objLocation);
        return ((ListMultimap)TAGS_INJECT.getUnchecked(registry)).put((Object)tagLocation, (Object)objLocation);
    }

    public static boolean registerRecipe(ResourceLocation location, IRecipeSerializer recipeSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(recipeSupplier);
        return RECIPES_INJECT.putIfAbsent(location, recipeSupplier) == null;
    }

    public static boolean registerLootTable(ResourceLocation location, Supplier<LootTable> lootTableSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(lootTableSupplier);
        return LOOT_TABLES_INJECT.putIfAbsent(location, lootTableSupplier) == null;
    }

    public static boolean registerAdvancement(ResourceLocation location, Supplier<Advancement.Builder> advancementBuilder) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(advancementBuilder);
        return ADVANCEMENTS_INJECT.putIfAbsent(location, advancementBuilder) == null;
    }

    public static Set<ResourceLocation> getInjectTags(ResourceKey<? extends Registry<?>> registry) {
        Objects.requireNonNull(registry);
        return ((ListMultimap)TAGS_INJECT.getUnchecked(registry)).keySet();
    }

    public static Set<ResourceLocation> getInjectRecipes() {
        return RECIPES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectLootTables() {
        return LOOT_TABLES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectAdvancements() {
        return ADVANCEMENTS_INJECT.navigableKeySet();
    }

    public static void findDataModules() {
        TreeMap<String, IDataModule> dataModules = new TreeMap<String, IDataModule>();
        List<ModFileScanData.AnnotationData> annotationData = ModList.get().getAllScanData().stream().flatMap(data -> data.getAnnotations().stream()).filter(data -> JAOPCA_DATA_MODULE.equals((Object)data.annotationType())).toList();
        Predicate<String> modVersionNotLoaded = MiscHelper.INSTANCE.modVersionNotLoaded(LOGGER);
        Predicate<String> classNotExists = MiscHelper.INSTANCE::classNotExists;
        for (ModFileScanData.AnnotationData aData : annotationData) {
            List modDeps = (List)aData.annotationData().get("modDependencies");
            List classDeps = (List)aData.annotationData().get("classDependencies");
            String className = aData.clazz().getClassName();
            if (modDeps != null && modDeps.stream().filter(Predicates.notNull()).anyMatch(modVersionNotLoaded)) {
                LOGGER.info("Data module {} has missing mod dependencies, skipping", (Object)className);
                continue;
            }
            if (classDeps != null && classDeps.stream().filter(Predicates.notNull()).anyMatch(classNotExists)) {
                LOGGER.info("Data module {} has missing class dependencies, skipping", (Object)className);
                continue;
            }
            try {
                IDataModule module;
                Class<?> moduleClass = Class.forName(className);
                Class<IDataModule> moduleInstanceClass = moduleClass.asSubclass(IDataModule.class);
                try {
                    Method method = moduleClass.getMethod("getInstance", new Class[0]);
                    module = (IDataModule)method.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    module = moduleInstanceClass.newInstance();
                }
                if (ConfigHandler.DATA_MODULE_BLACKLIST.contains(module.getName())) {
                    LOGGER.info("Data module {} is disabled in config, skipping", (Object)module.getName());
                }
                if (dataModules.putIfAbsent(module.getName(), module) != null) {
                    LOGGER.fatal("Data module name conflict: {} for {} and {}", (Object)module.getName(), ((IDataModule)dataModules.get(module.getName())).getClass(), module.getClass());
                    continue;
                }
                LOGGER.debug("Loaded data module {}", (Object)module.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.fatal("Unable to load data module {}", (Object)className, (Object)e);
            }
        }
        for (IDataModule module : dataModules.values()) {
            module.register();
        }
    }

    public static void reloadInject(Class<?> clazz, Object object) {
        for (Class c : ClassUtils.hierarchy(clazz, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE)) {
            if (!RELOAD_INJECTORS.containsKey(c)) continue;
            RELOAD_INJECTORS.get(c).accept(object);
            return;
        }
    }

    public static void injectRecipes(Object object) {
        Map recipeMap = (Map)object;
        TreeMap<ResourceLocation, JsonElement> recipesToInject = new TreeMap<ResourceLocation, JsonElement>();
        RECIPES_INJECT.forEach((key, supplier) -> {
            if (recipeMap.containsKey(key)) {
                LOGGER.debug("Duplicate recipe ignored with ID {}", key);
                return;
            }
            JsonElement recipe = null;
            try {
                recipe = (JsonElement)supplier.get();
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Recipe with ID {} received invalid arguments: {}", key, (Object)e.getMessage());
                return;
            }
            catch (Throwable e) {
                LOGGER.warn("Recipe with ID {} errored", key, (Object)e);
                return;
            }
            if (recipe == null) {
                LOGGER.debug("Recipe with ID {} returned null", key);
                return;
            }
            recipesToInject.put((ResourceLocation)key, recipe);
            LOGGER.debug("Injected recipe with ID {}", key);
        });
        recipesToInject.forEach(recipeMap::putIfAbsent);
        LOGGER.info("Injected {} recipes, {} recipes total", (Object)recipesToInject.size(), (Object)recipeMap.size());
    }

    public static JsonElement serializeTag(TagBuilder tagBuilder) {
        return (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(tagBuilder.m_215904_(), false)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    public static class PackFinder
    implements RepositorySource {
        public static final PackFinder INSTANCE = new PackFinder();

        public void m_7686_(Consumer<Pack> packConsumer, Pack.PackConstructor packConstructor) {
            Pack packInfo = Pack.m_10430_((String)"inmemory:jaopca", (boolean)true, () -> {
                InMemoryResourcePack pack = new InMemoryResourcePack("inmemory:jaopca", true);
                TAGS_INJECT.asMap().forEach((registry, map) -> {
                    String path = TagManager.m_203918_((ResourceKey)registry) + "/";
                    map.asMap().forEach((tagLocation, objLocations) -> {
                        TagBuilder builder = TagBuilder.m_215899_();
                        objLocations.forEach(l -> builder.m_215905_(l));
                        pack.putJson(PackType.SERVER_DATA, new ResourceLocation(tagLocation.m_135827_(), path + tagLocation.m_135815_() + ".json"), DataInjector.serializeTag(builder));
                    });
                });
                LOOT_TABLES_INJECT.forEach((location, supplier) -> pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "loot_tables/" + location.m_135815_() + ".json"), GSON.toJsonTree(supplier.get())));
                ADVANCEMENTS_INJECT.forEach((location, supplier) -> pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "advancements/" + location.m_135815_() + ".json"), (JsonElement)((Advancement.Builder)supplier.get()).m_138400_()));
                ModuleHandler.onCreateDataPack(pack);
                return pack;
            }, (Pack.PackConstructor)packConstructor, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_);
            if (packInfo != null) {
                packConsumer.accept(packInfo);
            }
        }
    }
}

