/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion;

import cofh.lib.fluid.FluidIngredient;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.compat.thermalexpansion.recipes.CentrifugeRecipeSerializer;
import thelm.jaopca.compat.thermalexpansion.recipes.ChillerRecipeSerializer;
import thelm.jaopca.compat.thermalexpansion.recipes.PressRecipeSerializer;
import thelm.jaopca.compat.thermalexpansion.recipes.PulverizerRecipeSerializer;
import thelm.jaopca.compat.thermalexpansion.recipes.SmelterRecipeSerializer;
import thelm.jaopca.compat.thermalexpansion.recipes.SmelterRecycleRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class ThermalExpansionHelper {
    public static final ThermalExpansionHelper INSTANCE = new ThermalExpansionHelper();

    private ThermalExpansionHelper() {
    }

    public FluidIngredient getFluidIngredient(Object obj, int amount) {
        return (FluidIngredient)this.getFluidIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidIngredient, Set<Fluid>> getFluidIngredientResolved(Object obj, int amount) {
        FluidIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        if (obj instanceof Supplier) {
            Pair<FluidIngredient, Set<Fluid>> pair = this.getFluidIngredientResolved(((Supplier)obj).get(), amount);
            ing = (FluidIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidIngredient) {
            ing = (FluidIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = FluidIngredient.of(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = FluidIngredient.of(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = FluidIngredient.of((TagKey)key, (int)amount);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            if (!stack.isEmpty()) {
                ing = FluidIngredient.of((FluidStack[])new FluidStack[]{stack});
                fluids.add(stack.getFluid());
            }
        } else if (obj instanceof FluidStack[]) {
            FluidStack[] stacks = (FluidStack[])obj;
            List<FluidStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.of(nonEmpty.stream());
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
            }
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            if (fluid != Fluids.f_76191_) {
                ing = FluidIngredient.of((FluidStack[])new FluidStack[]{new FluidStack(fluid, amount)});
                fluids.add(fluid);
            }
        } else if (obj instanceof Fluid[]) {
            Fluid[] fluidz = (Fluid[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.of(nonEmpty.stream().map(f -> new FluidStack(f, amount)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)obj;
            if (fluid.asFluid() != Fluids.f_76191_) {
                ing = FluidIngredient.of((FluidStack[])new FluidStack[]{new FluidStack(fluid.asFluid(), amount)});
                fluids.add(fluid.asFluid());
            }
        } else if (obj instanceof IFluidLike[]) {
            IFluidLike[] fluidz = (IFluidLike[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).map(IFluidLike::asFluid).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.of(nonEmpty.stream().map(f -> new FluidStack(f, amount)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof JsonElement) {
            ing = FluidIngredient.fromJson((JsonElement)((JsonElement)obj));
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        fluids.remove(Fluids.f_76191_);
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public boolean registerPulverizerRecipe(ResourceLocation key, Object input, int inputCount, Object[] output, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PulverizerRecipeSerializer(key, input, inputCount, output, energy, experience));
    }

    public boolean registerSmelterRecipe(ResourceLocation key, Object[] input, Object[] output, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new SmelterRecipeSerializer(key, input, output, energy, experience));
    }

    public boolean registerSmelterRecycleRecipe(ResourceLocation key, Object[] input, Object[] output, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new SmelterRecycleRecipeSerializer(key, input, output, energy, experience));
    }

    public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, float itemOutputChance, Object fluidOutput, int fluidOutputAmount, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSerializer(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, itemOutputChance, fluidOutput, fluidOutputAmount, energy, experience));
    }

    public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSerializer(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, fluidOutput, fluidOutputAmount, energy, experience));
    }

    public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, float itemOutputChance, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSerializer(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, itemOutputChance, energy, experience));
    }

    public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSerializer(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, energy, experience));
    }

    public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object itemOutput, int itemOutputCount, float itemOutputChance, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSerializer(key, input, inputCount, itemOutput, itemOutputCount, itemOutputChance, energy, experience));
    }

    public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object itemOutput, int itemOutputCount, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSerializer(key, input, inputCount, itemOutput, itemOutputCount, energy, experience));
    }

    public boolean registerChillerRecipe(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object itemInput, int itemInputCount, Object output, int outputCount, float outputChance, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChillerRecipeSerializer(key, fluidInput, fluidInputAmount, itemInput, itemInputCount, output, outputCount, outputChance, energy, experience));
    }

    public boolean registerChillerRecipe(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object itemInput, int itemInputCount, Object output, int outputCount, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChillerRecipeSerializer(key, fluidInput, fluidInputAmount, itemInput, itemInputCount, output, outputCount, energy, experience));
    }

    public boolean registerCentrifugeRecipe(ResourceLocation key, Object input, int inputCount, Object[] output, Object fluidOutput, int fluidOutputAmount, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CentrifugeRecipeSerializer(key, input, inputCount, output, fluidOutput, fluidOutputAmount, energy, experience));
    }

    public boolean registerCentrifugeRecipe(ResourceLocation key, Object input, int inputCount, Object[] output, int energy, float experience) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CentrifugeRecipeSerializer(key, input, inputCount, output, energy, experience));
    }
}

