/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ic2.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ic2.api.recipes.RecipeRegistry;
import ic2.api.recipes.ingridients.generators.ItemGenerator;
import ic2.api.recipes.ingridients.inputs.IInput;
import ic2.api.recipes.ingridients.inputs.IngredientInput;
import ic2.api.recipes.ingridients.recipes.IRecipeOutput;
import ic2.api.recipes.ingridients.recipes.SimpleRecipeOutput;
import ic2.api.recipes.misc.RecipeMods;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class MaceratorRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final double time;
    public final double energy;
    public final float experience;

    public MaceratorRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, double time, double energy, float experience) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
        this.energy = energy;
        this.experience = experience;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        IngredientInput input = new IngredientInput(ing, this.inputCount);
        CompoundTag mods = new CompoundTag();
        if (this.time != 1.0) {
            RecipeMods.RECIPE_TIME.create(mods, this.time);
        }
        if (this.energy != 1.0) {
            RecipeMods.ENERGY_USAGE.create(mods, this.energy);
        }
        SimpleRecipeOutput output = new SimpleRecipeOutput(List.of(new ItemGenerator((ItemLike)stack.m_41720_(), stack.m_41613_())), mods, this.experience);
        JsonObject json = new JsonObject();
        json.addProperty("type", "ic2:macerator");
        json.add("input", (JsonElement)RecipeRegistry.INGREDIENTS.serializeInput((IInput)input));
        json.add("output", (JsonElement)RecipeRegistry.INGREDIENTS.serializeOutput((IRecipeOutput)output));
        return json;
    }
}

