/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ic2;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.ic2.IC2DataInjector;
import thelm.jaopca.compat.ic2.IC2Helper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"ic2@[1.19.2-2.0.9,1.20)"})
public class IC2Module
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("aluminium", "aluminum", "copper", "gold", "iron", "silver", "tin", "uranium"));
    private Map<IMaterial, IDynamicSpecConfig> configs;

    public IC2Module() {
        IC2DataInjector.init();
    }

    @Override
    public String getName() {
        return "ic2";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        IC2Helper helper = IC2Helper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        Fluid biofuel = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("ic2:bio_fuel"));
        Fluid alcohol = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("ic2:alcohol"));
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerMaceratorRecipe(new ResourceLocation("jaopca", "ic2.ore_to_dust." + material.getName()), oreLocation, 1, dustLocation, 2, 1.0, 1.0, 0.5f);
            if (material.getType() != MaterialType.INGOT) continue;
            ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
            ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", material.getName(), "_");
            double multiplier = this.configs.get(material).getDefinedDouble("ic2.multiplier", 2.0, "The multiplier of this material's recipes in the refinery with respect to gold.");
            helper.registerMaceratorRecipe(new ResourceLocation("jaopca", "ic2.raw_material_to_dust." + material.getName()), rawMaterialLocation, 1, dustLocation, 2, 1.0, 1.0, 0.5f);
            helper.registerRefineryRecipe(new ResourceLocation("jaopca", "ic2.ore_to_raw_material_lava." + material.getName()), oreLocation, 1, Fluids.f_76195_, Mth.m_14165_((double)(25.0 * multiplier)), rawMaterialLocation, Mth.m_14165_((double)(1.0 * multiplier)), Mth.m_14165_((double)(3.0 * multiplier)), 0.5, 1.0);
            helper.registerRefineryRecipe(new ResourceLocation("jaopca", "ic2.ore_to_raw_material_bio_fuel." + material.getName()), oreLocation, 1, biofuel, Mth.m_14165_((double)(50.0 * multiplier)), rawMaterialLocation, Mth.m_14165_((double)(3.0 * multiplier)), Mth.m_14165_((double)(5.0 * multiplier)), 0.5, 1.0);
            helper.registerRefineryRecipe(new ResourceLocation("jaopca", "ic2.ore_to_raw_material_alcohol." + material.getName()), oreLocation, 1, alcohol, Mth.m_14165_((double)(25.0 * multiplier)), rawMaterialLocation, Mth.m_14165_((double)(5.0 * multiplier)), Mth.m_14165_((double)(7.0 * multiplier)), 0.5, 1.0);
            if (!itemTags.contains(rawStorageBlockLocation)) continue;
            helper.registerMaceratorRecipe(new ResourceLocation("jaopca", "ic2.raw_storage_block_to_dust." + material.getName()), rawStorageBlockLocation, 1, dustLocation, 18, 4.0, 1.0, 4.5f);
        }
    }
}

