/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class MineralWasherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputAmount;
    public final double experience;
    public final int time;
    public final double energy;

    public MineralWasherRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputAmount = outputAmount;
        this.experience = experience;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "electrodynamics:mineral_washer_recipe");
        JsonObject itemInputJson = new JsonObject();
        itemInputJson.addProperty("count", (Number)1);
        JsonObject itemIngJson = MiscHelper.INSTANCE.wrapIngredient(ing).m_43942_().getAsJsonObject();
        itemIngJson.addProperty("count", (Number)this.itemInputCount);
        itemInputJson.add("0", (JsonElement)itemIngJson);
        json.add("iteminputs", (JsonElement)itemInputJson);
        JsonObject fluidInputJson = new JsonObject();
        fluidInputJson.addProperty("count", (Number)1);
        JsonObject fluidIngJson = new JsonObject();
        if (this.fluidInput instanceof String || this.fluidInput instanceof ResourceLocation) {
            fluidIngJson.addProperty("tag", this.fluidInput.toString());
        } else {
            Object object = this.fluidInput;
            if (object instanceof Fluid) {
                Fluid fluid = (Fluid)object;
                fluidIngJson.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)fluid).toString());
            }
        }
        fluidIngJson.addProperty("amount", (Number)this.fluidInputAmount);
        fluidInputJson.add("0", (JsonElement)fluidIngJson);
        json.add("fluidinputs", (JsonElement)fluidInputJson);
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeFluidStack(stack));
        json.addProperty("experience", (Number)this.experience);
        json.addProperty("ticks", (Number)this.time);
        json.addProperty("usagepertick", (Number)this.energy);
        return json;
    }
}

