/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlock
extends Block
implements IMaterialFormBlock {
    private final IForm form;
    private final IMaterial material;
    protected final IBlockFormSettings settings;
    protected boolean blocksMovement;
    protected Supplier<SoundType> soundType;
    protected IntSupplier lightOpacity;
    protected IntSupplier lightValue;
    protected DoubleSupplier explosionResistance;
    protected DoubleSupplier friction;
    protected VoxelShape shape;
    protected VoxelShape interactionShape;
    protected IntSupplier flammability;
    protected IntSupplier fireSpreadSpeed;
    protected BooleanSupplier isFireSource;

    public JAOPCABlock(IForm form, IMaterial material, IBlockFormSettings settings) {
        super(JAOPCABlock.getProperties(form, material, settings));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.blocksMovement = settings.getBlocksMovement();
        this.soundType = MemoizingSuppliers.of(settings.getSoundTypeFunction(), () -> material);
        this.lightOpacity = MemoizingSuppliers.of(settings.getLightOpacityFunction(), () -> material);
        this.lightValue = MemoizingSuppliers.of(settings.getLightValueFunction(), () -> material);
        this.explosionResistance = MemoizingSuppliers.of(settings.getExplosionResistanceFunction(), () -> material);
        this.friction = MemoizingSuppliers.of(settings.getFrictionFunction(), () -> material);
        this.shape = settings.getShape();
        this.interactionShape = settings.getInteractionShape();
        this.flammability = MemoizingSuppliers.of(settings.getFlammabilityFunction(), () -> material);
        this.fireSpreadSpeed = MemoizingSuppliers.of(settings.getFireSpreadSpeedFunction(), () -> material);
        this.isFireSource = MemoizingSuppliers.of(settings.getIsFireSourceFunction(), () -> material);
    }

    public static BlockBehaviour.Properties getProperties(IForm form, IMaterial material, IBlockFormSettings settings) {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_60944_((Material)settings.getMaterialFunction().apply(material), (MaterialColor)settings.getMaterialColorFunction().apply(material));
        prop.m_60978_((float)settings.getBlockHardnessFunction().applyAsDouble(material));
        prop.m_60953_(state -> settings.getLightValueFunction().applyAsInt(material));
        if (settings.getRequiresToolFunction().test(material)) {
            prop.m_60999_();
        }
        prop.m_60955_();
        return prop;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public SoundType m_49962_(BlockState blockState) {
        return this.soundType.get();
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return this.lightOpacity.getAsInt();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.lightValue.getAsInt();
    }

    public float m_7325_() {
        return (float)this.explosionResistance.getAsDouble();
    }

    public float getFriction(BlockState blockState, LevelReader world, BlockPos pos, Entity entity) {
        return (float)this.friction.getAsDouble();
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.blocksMovement ? blockState.m_60808_(world, pos) : Shapes.m_83040_();
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter world, BlockPos pos) {
        return this.interactionShape;
    }

    public int getFlammability(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, LevelReader world, BlockPos pos, Direction side) {
        return this.isFireSource.getAsBoolean();
    }

    public MutableComponent m_49954_() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.form.getName(), this.material, this.m_7705_());
    }
}

