/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.energy;

import earth.terrarium.botarium.api.energy.EnergySnapshot;
import earth.terrarium.botarium.api.energy.SimpleEnergySnapshot;
import earth.terrarium.botarium.api.energy.StatefulEnergyContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ItemEnergyContainer
implements StatefulEnergyContainer<ItemStack> {
    private final long capacity;
    private long energy;

    public ItemEnergyContainer(ItemStack itemStack, long maxCapacity) {
        this.capacity = maxCapacity;
        this.deserialize(itemStack.m_41698_("BotariumData"));
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        long inserted = Mth.m_14053_((long)maxAmount, (long)0L, (long)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        long extracted = Mth.m_14053_((long)maxAmount, (long)0L, (long)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = energy;
    }

    @Override
    public long getStoredEnergy() {
        return this.energy;
    }

    @Override
    public long getMaxCapacity() {
        return this.capacity;
    }

    @Override
    public long maxInsert() {
        return 1024L;
    }

    @Override
    public long maxExtract() {
        return 1024L;
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128356_("Energy", this.energy);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.energy = tag.m_128454_("Energy");
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    @Override
    public void update(ItemStack stack) {
        this.serialize(stack.m_41698_("BotariumData"));
    }
}

