/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.media.items.ItemPrintout;
import java.util.Objects;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpeakerBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCCompatImpl {
    public static void setup() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)((IPeripheralProvider)ModRegistry.SPEAKER_BLOCK.get()));
    }

    public static int getPages(ItemStack itemstack) {
        return ItemPrintout.getPageCount((ItemStack)itemstack);
    }

    public static String[] getText(ItemStack itemstack) {
        return ItemPrintout.getText((ItemStack)itemstack);
    }

    public static boolean isPrintedBook(Item item) {
        return item instanceof ItemPrintout;
    }

    public static SpeakerBlock makeSpeaker(BlockBehaviour.Properties properties) {
        class SpeakerCC
        extends SpeakerBlock
        implements IPeripheralProvider {
            public SpeakerCC(BlockBehaviour.Properties properties) {
                super(properties);
            }

            public LazyOptional<IPeripheral> getPeripheral(Level world, BlockPos pos, Direction side) {
                BlockEntity tile = world.m_7702_(pos);
                if (tile instanceof SpeakerBlockTile) {
                    return tile.getCapability(Capabilities.CAPABILITY_PERIPHERAL, side);
                }
                return LazyOptional.empty();
            }
        }
        return new SpeakerCC(properties);
    }

    public static boolean isPeripheralCap(Capability<?> cap) {
        return cap == Capabilities.CAPABILITY_PERIPHERAL;
    }

    public static LazyOptional<Object> getPeripheralSupplier(SpeakerBlockTile tile) {
        return LazyOptional.of(() -> new SpeakerPeripheral(tile));
    }

    public static final class SpeakerPeripheral
    implements IPeripheral {
        private final SpeakerBlockTile tile;

        public SpeakerPeripheral(SpeakerBlockTile tile) {
            this.tile = tile;
        }

        @LuaFunction
        public void setNarrator(SpeakerBlockTile.Mode mode) {
            this.tile.setMode(mode);
            this.tile.m_6596_();
        }

        @LuaFunction
        public SpeakerBlockTile.Mode getMode() {
            return this.tile.getMode();
        }

        @LuaFunction
        public void setMessage(String message) {
            this.tile.setMessage(message);
            this.tile.m_6596_();
        }

        @LuaFunction
        public String getMessage() {
            return this.tile.getMessage();
        }

        @LuaFunction
        public void setName(String name) {
            this.tile.setCustomName((Component)Component.m_237113_((String)name));
            this.tile.m_6596_();
        }

        @LuaFunction
        public String getName() {
            return this.tile.m_7755_().getString();
        }

        @LuaFunction
        public double getVolume() {
            return this.tile.getVolume();
        }

        @LuaFunction
        public void setVolume(double volume) {
            this.tile.setVolume(volume);
            this.tile.m_6596_();
        }

        @LuaFunction
        public void activate() {
            this.tile.sendMessage();
        }

        @NotNull
        public String getType() {
            return "speaker_block";
        }

        public boolean equals(@Nullable IPeripheral other) {
            return Objects.equals(this, other);
        }

        public SpeakerBlockTile tile() {
            return this.tile;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SpeakerPeripheral that = (SpeakerPeripheral)obj;
            return Objects.equals((Object)this.tile, (Object)that.tile);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tile});
        }

        public String toString() {
            return "SpeakerPeripheral[tile=" + this.tile + "]";
        }
    }
}

