/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.client.QuiverArrowSelectGui;
import net.mehvahdjukaar.supplementaries.common.items.forge.QuiverItemImpl;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.QuiverTooltip;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class QuiverItem
extends Item
implements DyeableLeatherItem {
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public QuiverItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_142207_(ItemStack quiver, Slot pSlot, ClickAction pAction, Player pPlayer) {
        Data data;
        if (pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.m_7993_();
        AtomicBoolean didStuff = new AtomicBoolean(false);
        if (itemstack.m_41619_()) {
            Data data2 = QuiverItem.getQuiverData(quiver);
            if (data2 != null) {
                data2.removeOneStack().ifPresent(stack -> {
                    this.playRemoveOneSound((Entity)pPlayer);
                    data2.tryAdding(pSlot.m_150659_(stack));
                    didStuff.set(true);
                });
            }
        } else if (itemstack.m_41720_().m_142095_() && (data = QuiverItem.getQuiverData(quiver)) != null) {
            ItemStack taken = pSlot.m_150647_(itemstack.m_41613_(), itemstack.m_41741_(), pPlayer);
            ItemStack remaining = data.tryAdding(taken);
            if (!remaining.equals(taken)) {
                this.playInsertSound((Entity)pPlayer);
                didStuff.set(true);
            }
            pSlot.m_5852_(remaining);
        }
        return didStuff.get();
    }

    public boolean m_142305_(ItemStack quiver, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        Data data;
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer) && (data = QuiverItem.getQuiverData(quiver)) != null) {
            AtomicBoolean didStuff = new AtomicBoolean(false);
            if (pOther.m_41619_()) {
                data.removeOneStack().ifPresent(removed -> {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.m_142104_(removed);
                    didStuff.set(true);
                });
            } else {
                ItemStack i = data.tryAdding(pOther);
                if (!i.equals(pOther)) {
                    this.playInsertSound((Entity)pPlayer);
                    pAccess.m_142104_(i);
                    didStuff.set(true);
                }
            }
            return didStuff.get();
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pUsedHand) {
        ItemStack stack = player.m_21120_(pUsedHand);
        if (player.m_36341_()) {
            Data data = QuiverItem.getQuiverData(stack);
            if (data != null && data.cycle()) {
                this.playInsertSound((Entity)player);
            }
        } else {
            if (pLevel.f_46443_) {
                QuiverArrowSelectGui.setUsingItem(true);
            }
            this.playRemoveOneSound((Entity)player);
            player.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.f_46443_);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        return super.m_5922_(stack, level, livingEntity);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (level.f_46443_) {
            QuiverArrowSelectGui.setUsingItem(false);
        }
        this.playInsertSound((Entity)livingEntity);
        livingEntity.m_6674_(livingEntity.m_7655_());
        super.m_5551_(stack, level, livingEntity, timeCharged);
    }

    public boolean m_142522_(ItemStack pStack) {
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            return data.getSelected().m_41613_() > 0;
        }
        return false;
    }

    public int m_142158_(ItemStack pStack) {
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            return Math.min(1 + 12 * data.getSelectedArrowCount() / (data.getSelected().m_41741_() * data.getContentView().size()), 13);
        }
        return 0;
    }

    public int m_142159_(ItemStack pStack) {
        return BAR_COLOR;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            NonNullList list = NonNullList.m_122779_();
            boolean isEmpty = true;
            for (ItemStack v : data.getContentView()) {
                if (!v.m_41619_()) {
                    isEmpty = false;
                }
                list.add((Object)v);
            }
            if (!isEmpty) {
                return Optional.of(new QuiverTooltip(new ArrayList<ItemStack>(data.getContentView()), data.getSelectedSlot()));
            }
        }
        return Optional.empty();
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int c;
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null && (c = data.getSelectedArrowCount()) != 0) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"message.supplementaries.quiver.tooltip", (Object[])new Object[]{data.getSelected(null).m_41720_().m_41466_(), c}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_142023_(ItemEntity pItemEntity) {
        Data data = QuiverItem.getQuiverData(pItemEntity.m_32055_());
        if (data != null) {
            ItemUtils.m_150952_((ItemEntity)pItemEntity, data.getContentView().stream());
        }
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getQuiverData(ItemStack stack) {
        return QuiverItemImpl.getQuiverData(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack getQuiver(LivingEntity entity) {
        return QuiverItemImpl.getQuiver(entity);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Data data = QuiverItem.getQuiverData(stack);
        if (data != null) {
            data.updateSelectedIfNeeded();
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public static interface Data {
        public int getSelectedSlot();

        public void setSelectedSlot(int var1);

        public List<ItemStack> getContentView();

        default public boolean canAcceptItem(ItemStack toInsert) {
            return toInsert.m_41720_() instanceof ArrowItem;
        }

        default public ItemStack getSelected() {
            return this.getSelected(null);
        }

        default public ItemStack getSelected(@Nullable Predicate<ItemStack> supporterArrows) {
            List<ItemStack> content = this.getContentView();
            int selected = this.getSelectedSlot();
            if (supporterArrows == null) {
                return content.get(selected);
            }
            int size = content.size();
            for (int i = 0; i < size; ++i) {
                ItemStack s = content.get((i + selected) % size);
                if (!supporterArrows.test(s)) continue;
                return s;
            }
            return ItemStack.f_41583_;
        }

        default public boolean cycle() {
            return this.cycle(1);
        }

        default public boolean cycle(boolean clockWise) {
            return this.cycle(clockWise ? 1 : -1);
        }

        default public boolean cycle(int slotsMoved) {
            ItemStack selected;
            int originalSlot = this.getSelectedSlot();
            List<ItemStack> content = this.getContentView();
            if (slotsMoved == 0 && !(selected = content.get(this.getSelectedSlot())).m_41619_()) {
                return false;
            }
            int maxSlots = content.size();
            this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved %= maxSlots))) % maxSlots);
            for (int i = 0; i < maxSlots && (selected = content.get(this.getSelectedSlot())).m_41619_(); ++i) {
                this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved >= 0 ? 1 : -1))) % maxSlots);
            }
            return originalSlot != this.getSelectedSlot();
        }

        public ItemStack tryAdding(ItemStack var1, boolean var2);

        default public ItemStack tryAdding(ItemStack pInsertedStack) {
            return this.tryAdding(pInsertedStack, false);
        }

        public Optional<ItemStack> removeOneStack();

        default public int getSelectedArrowCount() {
            ItemStack selected = this.getSelected(null);
            int amount = 0;
            for (ItemStack item : this.getContentView()) {
                if (!ForgeHelper.canItemStack((ItemStack)selected, (ItemStack)item)) continue;
                amount += item.m_41613_();
            }
            return amount;
        }

        default public void updateSelectedIfNeeded() {
            this.cycle(0);
        }

        public void consumeArrow();
    }
}

